
/* #pragma pack (1) */

/***********************************************************/
/*    BITPUMP.H                                            */
/*    (C) Copyright 1993 by Rockwell Corporation           */
/*                                                         */
/*    This program is copyrighted by Rockwell Corporation  */
/*                                                         */
/* Description:                                            */
/*    Bytes and word operations macros.                    */
/*    Bitpump structure defenition.                        */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*    None                                                 */
/*                                                         */
/* List of H files included in this module:                */
/*                                                         */
/*                                                         */
/* Programer:                                              */
/*     Iris Shuker                30-August-1993           */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

/* Global Definitions */
#define RESET 0

/* Access RAM #defines */
#define LEC_ACCESS_RAM      0
#define NLEC_ACCESS_RAM     1
#define DFE_ACCESS_RAM      2
#define SCRATCH_ACCESS_RAM  3
#define EQ_ACCESS_RAM       4
#define MICRO_ACCESS_RAM    5


/* Define EQ memory addresses */
#define DAGC_HIGH        27
#define DAGC_LOW         26
#define LAST_FFE          7
#define FFE               0
#define EP               16
#define STAGE            35
#define FCELL__SU_FLAGS  36
#define OPEN_ATTEMPTS    37
#define STATUS           38
#define USER_SETUP       39
#define PARAMETERS       40
#define FELM_THRESHOLD   41
#define DAGC_VALUE       42
#define ERLE_SETUP       42
#define STAGE2           43

#ifdef NO_INDIRECT_RAM_VARS
#define EQ_RAM_BYTE_WIDTH       2
#define EQ_RAM_FIRST_VAR        35
#define EQ_RAM_LAST_VAR         43
#define NUM_EQ_RAM_VARS         (EQ_RAM_LAST_VAR - EQ_RAM_FIRST_VAR + 1)
#define NUM_SCRATCH_PAD_VARS    64
#endif


/* Handle Temperature/Environment Changes Stages */
#define TEMP_ENV_IDLE         0
#define TE_WAIT_FOR_METER     1
#define TE_HTUC_ADAPT_FFE     2
#define TE_HTUC_REBUILD       3

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

#define BP_WRITE_REG(ptr, reg, value)           ptr->reg = value
#define BP_WRITE_BIT(ptr, reg, bit, value)      ptr->reg.bit = value

#define BP_READ_REG(ptr, reg)                   ptr->reg
#define BP_READ_BIT(ptr, reg, bit)              ptr->reg.bit


#define LOW(x) (BP_S_8BIT)(x)

#define HIGH(x) LOW((x) >> 8)

#define HIGHER(x) LOW((x) >> 16)

#define HIGHEST(x) LOW((x) >> 24)

#define LOW_WORD(x) (BP_S_16BIT) (x)

#define HIGH_WORD(x) LOW_WORD((x) >> 16)

#define SET_WORD(ptr, low, high, value) \
    BP_WRITE_REG(ptr, low, LOW(value));\
    BP_WRITE_REG(ptr, high, HIGH(value));

#define SET_HIGH(x) (((BP_U_16BIT)(x)) << 8)

#define BYTE2WORD(x, y) (SET_HIGH(x) | (((BP_U_16BIT)(y)) & 0xFF))

#define BYTE2_32BIT(d,c,b,a)  \
( (BP_U_32BIT) ( (BP_U_32BIT)(BYTE2WORD(d,c))<<16) | ((BP_U_32BIT)(BYTE2WORD(b,a)) ))

#define SET_RESET(ptr, reg, bit) \
    BP_WRITE_BIT(ptr, reg, bit, ON);\
    DELAY2SYMBOL;\
    BP_WRITE_BIT(ptr, reg, bit, OFF);

#define GET_BITPUMP_TYPE()      BP_READ_BIT(bp_mode_ptr, global_modes, id)


/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/


#ifdef BIT_REVERSE
typedef BP_PACKED struct{
    BP_BIT_FIELD hw_revision:4;
    BP_BIT_FIELD id:3;
    BP_BIT_FIELD mode:1;
}BP_PACKED2 global_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD hclk_freq:2;
    BP_BIT_FIELD smon_source:6;
}BP_PACKED2 serial_monitor_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD t4:1;
    BP_BIT_FIELD t3:1;
    BP_BIT_FIELD snr:1;
    BP_BIT_FIELD meter:1;
    BP_BIT_FIELD sut4:1;
    BP_BIT_FIELD sut3:1;
    BP_BIT_FIELD sut2:1;
    BP_BIT_FIELD sut1:1;
}BP_PACKED2 timer_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD sync:1;
    BP_BIT_FIELD high_felm:1;
    BP_BIT_FIELD low_felm:1;
    BP_BIT_FIELD low_snr:1;
}BP_PACKED2 irq_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD imp_short:3;
    BP_BIT_FIELD rphs:4;
}BP_PACKED2 receive_select_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:3;
    BP_BIT_FIELD tbclk_pol:1;
    BP_BIT_FIELD rbclk_pol:1;
    BP_BIT_FIELD fifos_mode:1;
    BP_BIT_FIELD interface_mode:2;
}BP_PACKED2 cu_interface_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD enable_dc_tap:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD adapt_gain:2;
}BP_PACKED2 linear_ec_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD negate_symbol:1;
    BP_BIT_FIELD symbol_delay:3;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD adapt_gain:1;
}BP_PACKED2 nonlinear_ec_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD adapt_gain:1;
}BP_PACKED2 dfe_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD isolated_pulse:2;
    BP_BIT_FIELD transmitter_off:1;
    BP_BIT_FIELD htur_lfsr:1;
    BP_BIT_FIELD data_source:3;
}BP_PACKED2 tx_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved1:2;
    BP_BIT_FIELD reg_clk_en:1;
    BP_BIT_FIELD band_gap_test_mode:1;
    BP_BIT_FIELD reserved2:3;
    BP_BIT_FIELD async_mode:1;
}BP_PACKED2 misc_test_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD cont_time:2;
    BP_BIT_FIELD lb:2;
    BP_BIT_FIELD switch_cap_pole:1;
    BP_BIT_FIELD again:3;
}BP_PACKED2 adc_control_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD clk_freq:2;
    BP_BIT_FIELD negate_symbols:1;
    BP_BIT_FIELD phase_detector_gain:2;
    BP_BIT_FIELD freeze_pll:1;
    BP_BIT_FIELD pll_gain:2;
}BP_PACKED2 pll_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD enable_peak_detector:1;
    BP_BIT_FIELD output_mux_control:2;
    BP_BIT_FIELD scr_out_to_dfe:1;
    BP_BIT_FIELD two_level:1;
    BP_BIT_FIELD lfsr_lock:1;
    BP_BIT_FIELD htur_lfsr:1;
    BP_BIT_FIELD descr_on:1;
}BP_PACKED2 det_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:5;
    BP_BIT_FIELD eq_error_adaptation:1;
    BP_BIT_FIELD adapt_coefficient:1;
    BP_BIT_FIELD adapt_gain:1;
}BP_PACKED2 dagc_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD adapt_last_coeff:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD adapt_gain:1;
}BP_PACKED2 ffe_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD adapt_gain:1;
}BP_PACKED2 ep_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD band_gap_high:2;
    BP_BIT_FIELD tx_gain:4;
    BP_BIT_FIELD band_gap_low:2;
}BP_PACKED2 tx_gain_type;   

typedef BP_PACKED union{
    BP_U_8BIT setup;
    struct{
        BP_BIT_FIELD auto_tip_ring:1;
        BP_BIT_FIELD bt_other_side:1;
        BP_BIT_FIELD rx_descr:1;
        BP_BIT_FIELD tx_scr:1;
        BP_BIT_FIELD seq_source:1;
        BP_BIT_FIELD reserved:2;
        BP_BIT_FIELD terminal_flag:1;
    }bits;
}BP_PACKED2 user_setup_low_type;

typedef BP_PACKED union{
    BP_U_8BIT setup;
    struct{
        BP_BIT_FIELD test_mode:5;
        BP_BIT_FIELD activation_mode:1;
        BP_BIT_FIELD framer_format:2;
    }bits;
}BP_PACKED2 user_setup_high_type;

typedef BP_PACKED union{
    BP_U_8BIT status;
    struct{
        BP_BIT_FIELD normal_operation:1;
        BP_BIT_FIELD four_level_indication:1;
        BP_BIT_FIELD run_lost_timer:1;
        BP_BIT_FIELD nmr_ok:1;
        BP_BIT_FIELD activation_interval:1;
        BP_BIT_FIELD tip_ring_indication:1;
        BP_BIT_FIELD lost:1;
        BP_BIT_FIELD los:1;
    }bits;
}BP_PACKED2 status_reg_type;

typedef BP_PACKED union{
    BP_U_8BIT reg;
    struct{
        BP_BIT_FIELD reserved:2;
        BP_BIT_FIELD activation_timeout:2;
        BP_BIT_FIELD regenerator_mode:1;
        BP_BIT_FIELD operate_nlec:1;
        BP_BIT_FIELD hclk_select:2;
    }bits;
}BP_PACKED2 user_param_low_type;

#else /* not BIT_REVERSE */

typedef BP_PACKED struct{
    BP_BIT_FIELD mode:1;
    BP_BIT_FIELD id:3;
    BP_BIT_FIELD hw_revision:4;
}BP_PACKED2 global_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD smon_source:6;
    BP_BIT_FIELD hclk_freq:2;
}BP_PACKED2 serial_monitor_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD sut1:1;
    BP_BIT_FIELD sut2:1;
    BP_BIT_FIELD sut3:1;
    BP_BIT_FIELD sut4:1;
    BP_BIT_FIELD meter:1;
    BP_BIT_FIELD snr:1;
    BP_BIT_FIELD t3:1;
    BP_BIT_FIELD t4:1;
}BP_PACKED2 timer_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD low_snr:1;
    BP_BIT_FIELD low_felm:1;
    BP_BIT_FIELD high_felm:1;
    BP_BIT_FIELD sync:1;
    BP_BIT_FIELD reserved:4;
}BP_PACKED2 irq_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD rphs:4;
    BP_BIT_FIELD imp_short:3;
    BP_BIT_FIELD reserved:1;
}BP_PACKED2 receive_select_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD interface_mode:2;
    BP_BIT_FIELD fifos_mode:1;
    BP_BIT_FIELD rbclk_pol:1;
    BP_BIT_FIELD tbclk_pol:1;
    BP_BIT_FIELD reserved:3;
}BP_PACKED2 cu_interface_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD adapt_gain:2;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD enable_dc_tap:1;
    BP_BIT_FIELD reserved:2;
}BP_PACKED2 linear_ec_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD adapt_gain:1;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD symbol_delay:3;
    BP_BIT_FIELD negate_symbol:1;
}BP_PACKED2 nonlinear_ec_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD adapt_gain:1;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD reserved:4;
}BP_PACKED2 dfe_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD data_source:3;
    BP_BIT_FIELD htur_lfsr:1;
    BP_BIT_FIELD transmitter_off:1;
    BP_BIT_FIELD isolated_pulse:2;
    BP_BIT_FIELD reserved:1;
}BP_PACKED2 tx_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD async_mode:1;
    BP_BIT_FIELD reserved2:3;
    BP_BIT_FIELD band_gap_test_mode:1;
    BP_BIT_FIELD reg_clk_en:1;
    BP_BIT_FIELD reserved1:2;
}BP_PACKED2 misc_test_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD again:3;
    BP_BIT_FIELD switch_cap_pole:1;
    BP_BIT_FIELD lb:2;
    BP_BIT_FIELD cont_time:2;
}BP_PACKED2 adc_control_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD pll_gain:2;
    BP_BIT_FIELD freeze_pll:1;
    BP_BIT_FIELD phase_detector_gain:2;
    BP_BIT_FIELD negate_symbols:1;
    BP_BIT_FIELD clk_freq:2;
}BP_PACKED2 pll_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD descr_on:1;
    BP_BIT_FIELD htur_lfsr:1;
    BP_BIT_FIELD lfsr_lock:1;
    BP_BIT_FIELD two_level:1;
    BP_BIT_FIELD scr_out_to_dfe:1;
    BP_BIT_FIELD output_mux_control:2;
    BP_BIT_FIELD enable_peak_detector:1;
}BP_PACKED2 det_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD adapt_gain:1;
    BP_BIT_FIELD adapt_coefficient:1;
    BP_BIT_FIELD eq_error_adaptation:1;
    BP_BIT_FIELD reserved:5;
}BP_PACKED2 dagc_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD adapt_gain:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD adapt_last_coeff:1;
    BP_BIT_FIELD reserved:4;
}BP_PACKED2 ffe_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD adapt_gain:1;
    BP_BIT_FIELD adapt_coefficients:1;
    BP_BIT_FIELD zero_coefficients:1;
    BP_BIT_FIELD zero_output:1;
    BP_BIT_FIELD reserved:4;
}BP_PACKED2 ep_mode_type;

typedef BP_PACKED struct{
    BP_BIT_FIELD band_gap_low:2;
    BP_BIT_FIELD tx_gain:4;
    BP_BIT_FIELD band_gap_high:2;    
}BP_PACKED2 tx_gain_type;   

typedef BP_PACKED union{
    BP_U_8BIT setup;
    struct{
        BP_BIT_FIELD terminal_flag:1;
        BP_BIT_FIELD reserved:2;
        BP_BIT_FIELD seq_source:1;
        BP_BIT_FIELD tx_scr:1;
        BP_BIT_FIELD rx_descr:1;
        BP_BIT_FIELD bt_other_side:1;
        BP_BIT_FIELD auto_tip_ring:1;
    }bits;
}BP_PACKED2 user_setup_low_type;

typedef BP_PACKED union{
    BP_U_8BIT setup;
    struct{
        BP_BIT_FIELD framer_format:2;
        BP_BIT_FIELD activation_mode:1;
        BP_BIT_FIELD test_mode:5;
    }bits;
}BP_PACKED2 user_setup_high_type;

typedef BP_PACKED union{
    BP_U_8BIT reg;
    struct{
        BP_BIT_FIELD hclk_select:2;
        BP_BIT_FIELD operate_nlec:1;
        BP_BIT_FIELD regenerator_mode:1;
        BP_BIT_FIELD activation_timeout:2;
        BP_BIT_FIELD reserved:2;
    }bits;
}BP_PACKED2 user_param_low_type;

typedef BP_PACKED union{
    BP_U_8BIT status;
    struct{
        BP_BIT_FIELD los:1;
        BP_BIT_FIELD lost:1;
        BP_BIT_FIELD tip_ring_indication:1;
        BP_BIT_FIELD activation_interval:1;
        BP_BIT_FIELD nmr_ok:1;
        BP_BIT_FIELD run_lost_timer:1;
        BP_BIT_FIELD four_level_indication:1;
        BP_BIT_FIELD normal_operation:1;
    }bits;
}BP_PACKED2 status_reg_type;

#endif /* #else BIT_REVERSE */

typedef BP_PACKED struct{
    global_mode_type global_modes;                /* Address 0 */
    serial_monitor_type serial_monitor_source;    /* Address 1 */
    timer_type mask_low_reg;                      /* Address 2 */
    irq_type mask_high_reg;                       /* Address 3 */
    timer_type timer_source;                      /* Address 4 */
    irq_type irq_source;                          /* Address 5 */
    cu_interface_type cu_interface_modes;         /* Address 6 */
    receive_select_type receive_phase_select;     /* Address 7 */
    linear_ec_mode_type linear_ec_modes;          /* Address 8 */
    nonlinear_ec_mode_type nonlinear_ec_modes;    /* Address 9 */
    dfe_mode_type dfe_modes;                      /* Address 10 */
    tx_mode_type transmitter_modes;               /* Address 11 */
    timer_type timer_restart;                     /* Address 12 */
    timer_type timer_enable;                      /* Address 13 */
    timer_type timer_continous;                   /* Address 14 */
    misc_test_mode_type misc_test;                /* Address 15 */
    BP_U_16BIT sut1;                              /* Address 16 - 17 */
    BP_U_16BIT sut2;                              /* Address 18 - 19 */
    BP_U_16BIT sut3;                              /* Address 20 - 21 */
    BP_U_16BIT sut4;                              /* Address 22 - 23 */
    BP_U_16BIT meter_timer;                       /* Address 24 - 25 */
    BP_U_16BIT snr_timer;                         /* Address 26 - 27 */
    BP_U_16BIT t3;                                /* Address 28 - 29 */
    BP_U_16BIT t4;                                /* Address 30 - 31 */
    BP_U_8BIT register_32;                        /* Address 32 */
    adc_control_type adc_control;                 /* Address 33 */
    pll_mode_type pll_modes;                      /* Address 34 */
    BP_U_8BIT reserved6[5];                       /* Address 35 - 39 */
    tx_gain_type tx_calibrate;                    /* Address 40 */
    tx_gain_type tx_gain;                         /* Address 41 */
    BP_U_8BIT reserved2[16];                      /* Address 42 - 57 */
    det_mode_type detector_modes;                 /* Address 58 */
    BP_U_8BIT reserved7;                          /* Address 59 */
    dagc_mode_type dagc_modes;                    /* Address 60 */
    ffe_mode_type ffe_modes;                      /* Address 61 */
    ep_mode_type ep_modes;                        /* Address 62 */
    BP_U_8BIT reserved8[65];                      /* Address 63 - 127 */
}BP_PACKED2 transceiver_modes;

typedef BP_PACKED struct{
    BP_U_8BIT global_modes;                            /* Address 0 */
    BP_U_8BIT serial_monitor_source;                   /* Address 1 */
    BP_U_8BIT mask_low_reg;                            /* Address 2 */
    BP_U_8BIT mask_high_reg;                           /* Address 3 */
    BP_U_8BIT timer_source;                            /* Address 4 */
    BP_U_8BIT irq_source;                              /* Address 5 */
    BP_U_8BIT cu_interface_modes;                      /* Address 6 */
    BP_U_8BIT receive_phase_select;                    /* Address 7 */
    BP_U_8BIT linear_ec_modes;                         /* Address 8 */
    BP_U_8BIT nonlinear_ec_modes;                      /* Address 9 */
    BP_U_8BIT dfe_modes;                               /* Address 10 */
    BP_U_8BIT transmitter_modes;                       /* Address 11 */
    BP_U_8BIT timer_restart;                           /* Address 12 */
    BP_U_8BIT timer_enable;                            /* Address 13 */
    BP_U_8BIT timer_continous;                         /* Address 14 */
    BP_U_8BIT misc_test;                               /* Address 15 */
    BP_U_8BIT sut1_low;                                /* Address 16 */
    BP_U_8BIT sut1_high;                               /* Address 17 */
    BP_U_8BIT sut2_low;                                /* Address 18 */
    BP_U_8BIT sut2_high;                               /* Address 19 */
    BP_U_8BIT sut3_low;                                /* Address 20 */
    BP_U_8BIT sut3_high;                               /* Address 21 */
    BP_U_8BIT sut4_low;                                /* Address 22 */
    BP_U_8BIT sut4_high;                               /* Address 23 */
    BP_U_8BIT meter_low;                               /* Address 24 */
    BP_U_8BIT meter_high;                              /* Address 25 */
    BP_U_8BIT snr_timer_low;                           /* Address 26 */
    BP_U_8BIT snr_timer_high;                          /* Address 27 */
    BP_U_8BIT t3_low;                                  /* Address 28 */
    BP_U_8BIT t3_high;                                 /* Address 29 */
    BP_U_8BIT t4_low;                                  /* Address 30 */
    BP_U_8BIT t4_high;                                 /* Address 31 */
    BP_U_8BIT clock_freq;                              /* Address 32 */
    BP_U_8BIT adc_control;                             /* Address 33 */
    BP_U_8BIT pll_modes;                               /* Address 34 */
    BP_U_8BIT test_reg35;                              /* Address 35 */
    BP_S_8BIT pll_phase_offset_low;                    /* Address 36 */
    BP_S_8BIT pll_phase_offset_high;                   /* Address 37 */
    BP_S_8BIT dc_offset_low;                           /* Address 38 */
    BP_S_8BIT dc_offset_high;                          /* Address 39 */
    BP_S_8BIT tx_calibrate;                            /* Address 40 */
    BP_S_8BIT tx_gain;                                 /* Address 41 */
    BP_S_8BIT noise_histogram_th_low;                  /* Address 42 */
    BP_S_8BIT noise_histogram_th_high;                 /* Address 43 */
    BP_S_8BIT ep_pause_th_low;                         /* Address 44 */
    BP_S_8BIT ep_pause_th_high;                        /* Address 45 */
    BP_S_8BIT scr_sync_th;                             /* Address 46 */
    BP_U_8BIT reserved3;                               /* Address 47 */
    BP_S_8BIT far_end_high_alarm_th_low;               /* Address 48 */
    BP_S_8BIT far_end_high_alarm_th_high;              /* Address 49 */
    BP_S_8BIT far_end_low_alarm_th_low;                /* Address 50 */
    BP_S_8BIT far_end_low_alarm_th_high;               /* Address 51 */
    BP_S_8BIT snr_alarm_th_low;                        /* Address 52 */
    BP_S_8BIT snr_alarm_th_high;                       /* Address 53 */
    BP_S_8BIT cursor_level_low;                        /* Address 54 */
    BP_S_8BIT cursor_level_high;                       /* Address 55 */
    BP_S_8BIT dagc_target_low;                         /* Address 56 */
    BP_S_8BIT dagc_target_high;                        /* Address 57 */
    BP_U_8BIT detector_modes;                          /* Address 58 */
    BP_U_8BIT peak_detector_delay;                     /* Address 59 */
    BP_U_8BIT dagc_modes;                              /* Address 60 */
    BP_U_8BIT ffe_modes;                               /* Address 61 */
    BP_U_8BIT ep_modes;                                /* Address 62 */
    BP_U_8BIT reserved4;                               /* Address 63 */
    BP_S_8BIT pdm_low;                                 /* Address 64 */
    BP_S_8BIT pdm_high;                                /* Address 65 */
    BP_U_8BIT overflow_meter;                          /* Address 66 */
    BP_U_8BIT reserved5;                               /* Address 67 */
    BP_S_8BIT dc_meter_low;                            /* Address 68 */
    BP_S_8BIT dc_meter_high;                           /* Address 69 */
    BP_S_8BIT slm_low;                                 /* Address 70 */
    BP_S_8BIT slm_high;                                /* Address 71 */
    BP_S_8BIT felm_low;                                /* Address 72 */
    BP_S_8BIT felm_high;                               /* Address 73 */
    BP_S_8BIT noise_histogram_low;                     /* Address 74 */
    BP_S_8BIT noise_histogram_high;                    /* Address 75 */
    BP_S_8BIT ber_meter_low;                           /* Address 76 */
    BP_S_8BIT ber_meter_high;                          /* Address 77 */
    BP_U_8BIT symbol_histogram;                        /* Address 78 */
    BP_S_8BIT reserved6;                               /* Address 79 */
    BP_S_8BIT nlm_low;                                 /* Address 80 */
    BP_S_8BIT nlm_high;                                /* Address 81 */
    BP_U_8BIT reserved7[12];                           /* Address 82-93 */
    BP_S_8BIT vcxo_frequency_low;                      /* Address 94 */
    BP_S_8BIT vcxo_frequency_high;                     /* Address 95 */
    BP_U_8BIT reserved8[16];                           /* Address 96 - 111 */
    BP_U_8BIT linear_ec_tap_select_read;               /* Address 112 */
    BP_U_8BIT linear_ec_tap_select_write;              /* Address 113 */
    BP_U_8BIT nonlinear_ec_tap_select_read;            /* Address 114 */
    BP_U_8BIT nonlinear_ec_tap_select_write;           /* Address 115 */
    BP_U_8BIT dfe_tap_select_read;                     /* Address 116 */
    BP_U_8BIT dfe_tap_select_write;                    /* Address 117 */
    BP_U_8BIT scratch_pad_tap_select_read;             /* Address 118 */
    BP_U_8BIT scratch_pad_tap_select_write;            /* Address 119 */
    BP_U_8BIT eq_add_read;                             /* Address 120 */
    BP_U_8BIT eq_add_write;                            /* Address 121 */
    BP_U_8BIT eq_microcode_add_read;                   /* Address 122 */
    BP_U_8BIT eq_microcode_add_write;                  /* Address 123 */
    BP_S_8BIT access_data_byte0;                       /* Address 124 */
    BP_S_8BIT access_data_byte1;                       /* Address 125 */
    BP_S_8BIT access_data_byte2;                       /* Address 126 */
    BP_S_8BIT access_data_byte3;                       /* Address 127 */
}BP_PACKED2 transceiver;

typedef BP_PACKED union{
    struct{
        BP_U_8BIT timer_source;
        BP_U_8BIT irq_source;
    }bytes;
    struct{
        timer_type timer_source;
        irq_type irq_source;
    }bits;
}BP_PACKED2 interrupt_reg;

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

void _HandleFlags(BP_U_8BIT no);
#ifdef TEMP_ENV
void _HandleTempEnv(BP_U_8BIT no);
BP_U_8BIT _GetMeterIntervalElapsed(BP_U_8BIT no);
BP_U_8BIT _GetTeMeterIntervalElapsed(BP_U_8BIT no);
#endif
