/************************************************************/
/*    API.H                                                 */
/*    (C) Copyright 1993 by Rockwell Corporation            */
/*                                                          */
/*    This program is copyrighted by Rockwell Corporation   */
/*                                                          */
/* Description:                                             */
/*    API constants defenitions.                            */
/*                                                          */
/* Notes:                                                   */
/*                                                          */
/* User Modifiable Code:                                    */
/*    None                                                  */
/*                                                          */
/* List of H files included in this module:                 */
/*                                                          */
/* Programer:                                               */
/*     Iris Shuker                21-Oct-1993               */
/*                                                          */
/* Revision History:                                        */
/*                                                          */
/************************************************************/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

#define DEST(x)                  ((x) & 0x0F)

/* Bit-pump Types */
#define BT8952         0
#define BT8960         1
#define BT8970         2
#define BT8973         3

#define _PASS 0
#define _FAIL 1

#define _PRESENT                   0x1
#define _NOT_PRESENT               0x0

/* Message opcodes */
/* Control Commands */
#define _TERMINAL_TYPE            0x01
#define _ANALOG_AGC_CONFIG        0x02
#define _STARTUP_SEQ_SOURCE       0x03
#define _TRANSMIT_SCR             0x04
#define _RECEIVE_DESCR            0x05
#define _FRAMER_FORMAT            0x06
#define _BT_OTHER_SIDE            0x07
#define _LOST_TIME_PERIOD         0x08
#define _SYSTEM_CONFIG            0x09
#define _TRANSMIT_EXT_DATA        0x0A
#define _ACTIVATE                 0x0B
#define _DEACTIVATE               0x0C
#define _TEST_MODE                0x0D
#define _SYM_RATE                 0x0E
#define _RESET_SYSTEM             0x0F
#define _OPERATE_NLEC             0x11
#define _WRITE_TX_GAIN            0x13
#define _REVERSE_TIP_RING         0x14
#define _BER_METER_START          0x15
#define _BER_METER_STOP           0x16
#define _AUTO_TIP_RING            0x17
#define _ERLE_TEST_MODE           0x18
#define _ZIP_START_UPDATE         0x19
#define _ZIP_START_CONFIG         0x20
#define _HCLK_SELECT              0x21
#define _SYM_RATE_HI              0x22
#define _ACTIVATION_TIMEOUT       0x23
#define _REGENERATOR_MODE         0x24
#define _TE_METER_INTERVALS       0x25
#define _ACTIVATION_TIMER         0x26

#ifdef _CHAR_TESTING
#define _SET_IMP_SHORT        0x70
#define _SET_CONT_TIME        0x71
#define _SET_SWITCH_CAP       0x72
#define _HALF_DUPLEX_MODE     0x73
#endif


/* Status Requests Commands */
#define _SLM                      0x80
#define _DC_METER                 0x81
#define _FELM                     0x82
#define _NMR                      0x83
#define _TIMING_RECOVERY_CONTROL  0x84
#define _STARTUP_STATUS           0x85
#define _LEC_COEFF                0x86
#define _NLEC_COEFF               0x87
#define _EQ_COEFF                 0x88
#define _DFE_COEFF                0x89
#define _VERSION                  0x8A
#define _BIT_PUMP_PRESENT         0x8B
#define _SELF_TEST                0x8C
#define _REGISTER                 0x8D
#define _CONFIGURATION            0x8E
#define _STAGE_NUMBER             0x8F
#define _AAGC_VALUE               0x90
#define _READ_TX                  0x91
#define _BER_METER_STATUS         0x92
#define _ERLE_RESULTS             0x93
#define _AAGC_RESULTS             0x94
#define _METER_INTERVAL_STATUS    0x95
#define _TE_METER_INTERVAL_STATUS 0x96

/* Available parameters */
/* Terminal type */
#define _HTUC            0
#define _HTUR            1

/* Activation Options */
#define _ACTIVATE_COLD   0
#define _ACTIVATE_ZIP    1

/* Analog AGC config */
#define _NO_AGC          0
#define _TWO_LEVEL_AGC   1
#define _FOUR_LEVEL_AGC  2
#define _SIX_LEVEL_AGC   3

/* Startup sequence source */
#define _INTERNAL        1
#define _EXTERNAL        0

/* Transmit scrambler /Receive descrambler */
#define _ACTIVATE_SCR    1
#define _ACTIVATE_DESCR  1
#define _BYPASS          0

/* Framer Format */
#define _PARALLEL_MASTER 0
#define _PARALLEL_SLAVE  1
#define _SERIAL          2
#define _SERIAL_SWAP     3

/* Clock Polarity for channel unit interface */
#define _RISING_EDGE	 0
#define _FALLING_EDGE	 1

/* Bt other side */
#define _BT              1
#define _NO_BT           0

/* PLL Frequency */
#define FOUR_CHANNEL_60  0
#define SIX_CHANNEL_60   1
#define TWO_CHANNEL_60   2
#define EIGHT_CHANNEL_60 3

#define HALF_E1_70       0
#define HALF_T1_70       1
#define EIGHT_CHANNEL_70 2
#define FULL_T1_70       3

/* To maintain backwards compatibility with previus versions */
#define HALF_E1          0
#define HALF_T1          1
#define EIGHT_CHANNEL    2
#define FULL_T1          3

/* Test Modes */
#define _EXIT_TEST_MODE                 0
#define _ANALOG_LOOPBACK                1
#define _NEAR_LOOPBACK                  2
#define _FAR_LOOPBACK                   3
#define _ISOLATED_PULSE_PLUS3           4
#define _ISOLATED_PULSE_PLUS1           5
#define _ISOLATED_PULSE_MINUS1          6
#define _ISOLATED_PULSE_MINUS3          7
#define _FOUR_LEVEL_SCR                 8
#define _TWO_LEVEL_SCR                  9
#define _VCXO_NOMINAL                  10
#define _VCXO_MIN                      11
#define _VCXO_MAX                      12
#define _INTERNAL_ANALOG_LOOPBACK      13
#define _ISOLATED_ANALOG_LOOPBACK      14
#define _ERLE_TEST                     15
#define _MEASURE_AAGC                  16
#define _ALTERNATING_SYMBOLS_3         17
#define _ALTERNATING_SYMBOLS_1         18

/* Bitpump Configuration */
#define _USER_SETUP_LOW_BYTE   0
#define _USER_SETUP_HIGH_BYTE  1
#define _LOST                  2
#define _BIT_RATE              3
#define _ERLE_SETUP_CONFIG     4
#define _BIT_RATE_HI           5
#define _USER_PARAM_LOW_BYTE   6

/* Tip/Ring Reversal */
#define TIP_RING_NORMAL     0
#define TIP_RING_REVERSE    1

/* Auto Tip/Ring */
#define AUTO_TIP_RING_OFF   0
#define AUTO_TIP_RING_ON    1


/* NLEC */
#define _NLEC_OFF     0x0
#define _NLEC_ON      0x1

/* VERSIONS */
#define _HW_SW_VERSIONS    0
#define _MAJOR_SW_VERSION  1
#define _MINOR_SW_VERSION  2
#define _HW_TYPE_VERSIONS  3
#define _ZIP_MAJOR_VERSION 4
#define _ZIP_MINOR_VERSION 5

/* READ TX  */
#define _CALIBRATION  0x0
#define _GAIN         0x1

/* HCLK Select Options */
#define _HCLK_DEFAULT   0
#define _HCLK_16_TIMES  1
#define _HCLK_32_TIMES  2
#define _HCLK_64_TIMES  3

/* Maximum possible between Bt8960 & Bt8970 */
#define MAX_NUM_LEC_COEFFS  120
#define MAX_NUM_DFE_COEFFS  116

/* Access Data Byte RAM */
#define NUM_LEC_COEFFS      ((GET_BITPUMP_TYPE()==BT8960)?60:120)
#define NUM_NLEC_COEFFS     64
#define NUM_EQ_COEFFS       48
#define NUM_DFE_COEFFS      ((GET_BITPUMP_TYPE()==BT8960)?58:116)

/* Define Smon source */
#define _ECHO_FREE_SIGNAL       0x1E
#define _EQ_ERROR               0x21
#define _SLICER_ERROR           0x22
#define _DAGC_OUTPUT            0x1C
#define _FFE_OUTPUT             0x1D

/* Stage Numbers */
#define _ACTIVATION_STAGE       0x00
#define _TEMP_ENV_STAGE         0x01
#define _TEST_MODE_STAGE        0x02

/* Activation Timeout */
#define _ACT_TIME_30SEC         0x00
#define _ACT_TIME_52SEC         0x01
#define _ACT_TIME_VARIABLE      0x02

/* Regenerator Mode */
#define _REGENERATOR_OFF        0x00
#define _REGENERATOR_ON         0x01

#ifdef BER_METER
#define _BER_STATUS                 0
#define _BER_BIT_ERRORS_LOW         1
#define _BER_BIT_ERRORS_HIGH        2
#define _BER_METER_INTERVALS_LOW    3
#define _BER_METER_INTERVALS_HIGH   4
#endif

#ifdef ERLE
#define _ERLE_SLM_LOW            0
#define _ERLE_SLM_HIGH           1
#define _ERLE_FELM_LOW           2
#define _ERLE_FELM_HIGH          3
#define _ERLE_SLM2_LOW           4
#define _ERLE_SLM2_HIGH          5
#define _ERLE_DC_OFFSET_LOW      6
#define _ERLE_DC_OFFSET_HIGH     7

enum {_AAGC_SLM_0_LOW = 0, 
      _AAGC_SLM_0_HIGH, 
      _AAGC_SLM_3_LOW, 
      _AAGC_SLM_3_HIGH,
      _AAGC_SLM_6_LOW,
      _AAGC_SLM_6_HIGH,
      _AAGC_SLM_9_LOW,
      _AAGC_SLM_9_HIGH,
      _AAGC_SLM_12_LOW,
      _AAGC_SLM_12_HIGH,
      _AAGC_SLM_15_LOW,
      _AAGC_SLM_15_HIGH };
          
#endif


/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

#if 0
#define _BtControl   _BitpumpControl
#define _BtStatus    _BitpumpStatus
#endif

/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

BP_U_8BIT _BitpumpStatus(BP_U_8BIT no, BP_U_8BIT opcode, BP_U_8BIT parameter, BP_S_8BIT *indication);
BP_U_8BIT _BitpumpControl(BP_U_8BIT no, BP_U_8BIT opcode, BP_U_8BIT parameter);
