/*
 * In-memory structures for the upload process
 *
 * We impose an arbitrary file size limit of 128 KB (256 RT11FFS AUs).
 * We have that much RAM set aside for the upload buffer.  If it's an
 * XMODEM upload of a binary file, everything is counted in blocks from
 * start to finish (receive 128-byte XMODEM blocks, then pad to an RT-11
 * block if necessary).
 *
 * If it's an ASCII text file, we impose a line structure.  Only
 * printable characters are allowed, and we allow a max of 126 chars
 * per line here (not including termination) so we can use printf for
 * sanity checking.  We allow a max of 1000 lines - combining the two
 * limits puts us within our total file size limit.
 */

#define	BUFFER_BASE	0x80000

#define	MAX_XMODEM_BLOCKS	1024
#define	MAX_LINE_LEN		126
#define	MAX_LINES		1000

struct lineinfo {
	char	*text;
	int	len;
};
