#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"
#include "../flashw/api.h"
#include "monitor_api.h"
#include "memstruct.h"

extern struct flashw_api_table *fetch_flashw();

struct flashw_api_table *flashw_api;
u_short filename[3];
struct ffs_create_options createopts;

int blocks_in_buffer;	/* that's RT-11 blocks */
int lines_in_buffer;	/* for ASCII text files only */
struct lineinfo line_array[MAX_LINES];
char *text_endp;

char *
prompt()
{
	static char buf[80];
	char *cp;
	int count, ch, ctrlc;

	ctrlc = 0;
init:	cp = buf;
	count - 0;
	for (;;) {
		ch = toascii(getchar());
		switch (ch) {
		case '\0':	/* ignore NULs */
			continue;
		case 0x03:	/* ^C */
			printf("^C\r\n");
			if (ctrlc)
				return(0);
			printf("(Press ^C one more time to abort this program)\r\n");
			ctrlc = 1;
			goto init;
		case 0x08:	/* BS */
		case 0x7F:	/* DEL */
			if (!count)
				continue;
			printf("\b \b");
			cp--;
			count--;
			continue;
		case '\r':	/* CR */
			printf("\r\n");
			*cp = '\0';
			return(buf);
		case 0x15:	/* ^U */
			printf("^U\r\n");
			goto init;
		}
		if (iscntrl(ch) || count == 79) {
			putchar(0x07);
			continue;
		}
		putchar(ch);
		*cp++ = ch;
		count++;
	}
}

mymain()
{
	char *answer;
	struct segment_scan_results scan[FFS_NSEGS];
	int i, freeblocks;

	flashw_api = fetch_flashw();
	if (!flashw_api)
		return;
	printf("This is the file upload utility\r\n");
	printf("for the DSU's on-board flash file system.\r\n\r\n");
	printf("Please select the file upload type:\r\n\r\n");
	printf("A:  ASCII upload\r\n");
	printf("X:  XMODEM upload (binary)\r\n");
	printf("XA: XMODEM upload, but file intended to be ASCII\r\n");
	printf("    (performs some extra sanity checks and cleanup)\r\n");
	printf("Q:  Quit (cancel upload)\r\n\r\n");
	printf("Please make your selection: ");
	answer = prompt();
	if (!answer || answer[0] == 'Q' || answer[0] == 'q')
		return;
	if (!strcasecmp(answer, "A")) {
		if (ascii_upload() < 0)
			return;
		ascii_zeropad();
	} else if (!strcasecmp(answer, "X")) {
		if (xmodem_upload() < 0)
			return;
	} else if (!strcasecmp(answer, "XA")) {
		printf("XA mode not implemented yet\r\n");
		return;
	} else {
		printf("Selection not understood, exiting\r\n");
		return;
	}

	/* ensure free space available */
	monapi_scanffs(0, scan);
	for (i = 0, freeblocks = 0; i < FFS_NSEGS; i++)
		if (scan[i].valid_seg && !scan[i].has_errs)
			freeblocks += scan[i].free_blocks;
	if (freeblocks < blocks_in_buffer) {
		monapi_error("Not enough free space to store the new file");
		return;
	}

fnloop:	printf("\r\nFilename to store under (6.3): ");
	answer = prompt();
	if (!answer)
		return;
	if (!answer[0])
		goto fnloop;
	if (ascii_to_rad50_filename(answer, strlen(answer), filename, 0) < 0) {
		printf("The entry is not a valid RT-11 filename\r\n");
		goto fnloop;
	}
	createopts.overwrite = 1;
	createopts.startseg = 0;
	createopts.contig = 0;
	i = flashw_api->ffs_create_file(filename, blocks_in_buffer,
					BUFFER_BASE, &createopts);
	if (!i)
		printf("File successfully written to FFS\r\n");
	return;
}
