#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"

char *
prompt()
{
	static char buf[80];
	char *cp;
	int count, ch, ctrlc;

	ctrlc = 0;
init:	cp = buf;
	count - 0;
	for (;;) {
		ch = toascii(getchar());
		switch (ch) {
		case '\0':	/* ignore NULs */
			continue;
		case 0x03:	/* ^C */
			printf("^C\r\n");
			if (ctrlc)
				return(0);
			printf("(Press ^C one more time to abort this program)\r\n");
			ctrlc = 1;
			goto init;
		case 0x08:	/* BS */
		case 0x7F:	/* DEL */
			if (!count)
				continue;
			printf("\b \b");
			cp--;
			count--;
			continue;
		case '\r':	/* CR */
			printf("\r\n");
			*cp = '\0';
			return(buf);
		case 0x15:	/* ^U */
			printf("^U\r\n");
			goto init;
		}
		if (iscntrl(ch) || count == 79) {
			putchar(0x07);
			continue;
		}
		putchar(ch);
		*cp++ = ch;
		count++;
	}
}
