#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"
#include "../flashw/api.h"
#include "monitor_api.h"
#include "memstruct.h"

extern struct flashw_api_table *fetch_flashw();
extern char *prompt();

struct flashw_api_table *flashw_api;
struct ffs_create_options createopts;
u_short *filename_rad50;
char *filename_ascii;

int blocks_in_buffer;	/* that's RT-11 blocks */
int lines_in_buffer;	/* for ASCII text files only */
char *text_endp;

static const u_short oper_cmd_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x6045, 0x7080, 0x14CC};
static const u_short config_txt_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x1526, 0x26EF, 0x80D4};
static const u_short vclist_txt_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x8A04, 0x3B4C, 0x80D4};
static const u_short hwconf_txt_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x359B, 0x5FF6, 0x80D4};

mymain()
{
	char *answer;
	struct segment_scan_results scan[FFS_NSEGS];
	int i, freeblocks;

	flashw_api = fetch_flashw();
	if (!flashw_api)
		return;
	printf("This is the manual configuration file upload utility\r\n");
	printf("for the DSU's on-board flash file system.\r\n\r\n");
	printf("Please select which file you would like to upload:\r\n\r\n");
	printf("1: OPER.CMD\r\n");
	printf("2: CONFIG.TXT\r\n");
	printf("3: VCLIST.TXT\r\n");
	printf("Q: Quit (cancel upload)\r\n\r\n");
	printf("Please make your selection: ");
	answer = prompt();
	if (!answer || answer[0] == 'Q' || answer[0] == 'q')
		return;
	if (!strcmp(answer, "1")) {
		filename_rad50 = oper_cmd_filename;
		filename_ascii = "OPER.CMD";
	} else if (!strcmp(answer, "2")) {
		filename_rad50 = config_txt_filename;
		filename_ascii = "CONFIG.TXT";
	} else if (!strcmp(answer, "3")) {
		filename_rad50 = vclist_txt_filename;
		filename_ascii = "VCLIST.TXT";
	} else if (!strcasecmp(answer, "HW")) {
		filename_rad50 = hwconf_txt_filename;
		filename_ascii = "HWCONF.TXT";
	} else {
		printf("Selection not understood, exiting\r\n");
		return;
	}
	if (ascii_upload() < 0)
		return;
	ascii_zeropad();

	/* ensure free space available */
	monapi_scanffs(0, scan);
	for (i = 0, freeblocks = 0; i < FFS_NSEGS; i++)
		if (scan[i].valid_seg && !scan[i].has_errs)
			freeblocks += scan[i].free_blocks;
	if (freeblocks < blocks_in_buffer) {
		monapi_error("Not enough free space to store the new file");
		return;
	}

cfloop:	printf("\r\nPlease type CONFIRM to store the new %s file in FFS\r\n",
		filename_ascii);
	printf("or press Control-C to cancel.\r\n");
	answer = prompt();
	if (!answer || !strcasecmp(answer, "ABORT"))
		return;
	if (strcasecmp(answer, "CONFIRM"))
		goto cfloop;

	createopts.overwrite = 1;
	createopts.startseg = 0;
	createopts.contig = 0;
	i = flashw_api->ffs_create_file(filename_rad50, blocks_in_buffer,
					BUFFER_BASE, &createopts);
	if (!i)
		printf("File successfully written to FFS\r\n");
	return;
}
