#include <sys/param.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define	RT11FFS_AU_SIZE		0x200

struct rt11ffs_dirent {
	u_short	filename[3];
	u_short	size_flags;
};
/* masks for the last word */
#define	RT11FFS_DIRENT_VALID		0x8000
#define	RT11FFS_DIRENT_FIRST		0x4000
#define	RT11FFS_DIRENT_LAST		0x2000
#define	RT11FFS_DIRENT_SIZEMASK		0x1FFF

struct rt11ffs_dirent segment_header;
u_char rt11ffs_signature[6] = {0x73, 0xBF, 0xC1, 0xC0, 0x26, 0x83};
u_long segment_size;
u_char *segbuf;
int segment_going;
u_short *dirent_ptr;
u_char *datablk_ptr;
int dirents_left, free_blocks;

ascii_to_rad50_word(ascii, rad50)
	char ascii[3];
	u_short *rad50;
{
	int i;
	u_short accum = 0;

	for (i = 0; i <= 2; i++) {
		char ch;
		u_char rchar;

		ch = ascii[i];
		if (isupper(ch))
			rchar = ch - 'A' + 001;
		else if (islower(ch))
			rchar = ch - 'a' + 001;
		else if (isdigit(ch))
			rchar = ch - '0' + 036;
		else if (ch == ' ')
			rchar = 000;
		else if (ch == '$')
			rchar = 033;
		else if (ch == '.')
			rchar = 034;
		else
			return(-1);
		accum = accum * 050 + rchar;
	}
	*rad50 = htons(accum);
	return(0);
}

ascii_to_rad50_filename(asc, rad50)
	char *asc;
	u_short *rad50;
{
	char filename[6], filetype[3];
	char *cp, *dp;
	int i;

	for (cp = asc, dp = filename, i = 0; *cp; i++) {
		if (*cp == '.')
			break;
		if (!isalnum(*cp) && *cp != '$')
			return(-1);
		if (i >= 6)
			return(-1);
		*dp++ = *cp++;
	}
	if (!i)
		return(-1);
	for (; i < 6; i++)
		*dp++ = ' ';
	ascii_to_rad50_word(filename, rad50);
	ascii_to_rad50_word(filename + 3, rad50 + 1);
	if (!*cp) {
		rad50[2] = 0;
		return(0);
	}
	*cp++;	/* skip '.' */
	for (dp = filetype, i = 0; *cp; i++) {
		if (!isalnum(*cp) && *cp != '$')
			return(-1);
		if (i >= 3)
			return(-1);
		*dp++ = *cp++;
	}
	for (; i < 3; i++)
		*dp++ = ' ';
	ascii_to_rad50_word(filetype, rad50 + 2);
	return(0);
}

main(argc, argv)
	char **argv;
{
	char *cp;
	char **ap;

	if (argc < 3) {
usage:		fprintf(stderr, "usage: mkrt11ffs erase_blk_size files...\n");
		exit(1);
	}
	segment_size = strtoul(argv[1], &cp, 0);
	if (*cp)
		goto usage;
	if (!ispowerof2(segment_size) || segment_size < 0x4000 ||
	    segment_size > 0x01000000) {
		fprintf(stderr, "mkrt11ffs: %lu is not a valid segment size\n",
			segment_size);
		exit(1);
	}
	segbuf = (u_char *)malloc(segment_size);
	if (!segbuf) {
		perror("malloc");
		exit(1);
	}
	bcopy(rt11ffs_signature, segment_header.filename, 6);
	segment_header.size_flags = htons(segment_size >> 9);

	for (ap = argv + 2; *ap; ap++)
		add_file(*ap);
	if (segment_going)
		flush_segment();

	exit(0);
}

add_file(pathname)
	char *pathname;
{
	int fd;
	struct stat st;
	int nblocks, blocks_left, pad, fragsize;
	char *cp;
	u_short filename[3], sizefield, flags;

	fd = open(pathname, O_RDONLY);
	if (fd < 0) {
		perror(pathname);
		exit(1);
	}
	fstat(fd, &st);
	if (!st.st_size) {
		fprintf(stderr, "%s: zero length file not allowed\n", pathname);
		exit(1);
	}
	nblocks = (st.st_size + 0x1FF) >> 9;
	pad = nblocks * RT11FFS_AU_SIZE - st.st_size;
	cp = rindex(pathname, '/');
	if (cp)
		cp++;
	else
		cp = pathname;
	if (ascii_to_rad50_filename(cp, filename) < 0) {
		fprintf(stderr,
			"%s: file name doesn't meet RAD50 requirements\n",
			pathname);
		exit(1);
	}

	flags = RT11FFS_DIRENT_VALID | RT11FFS_DIRENT_FIRST;
	for (blocks_left = nblocks; blocks_left; ) {
		if (!segment_going)
			start_segment();
		if (!dirents_left) {
			fprintf(stderr,
		"mkrt11ffs: I can't make secondary directory blocks!\n");
			exit(1);
		}
		fragsize = blocks_left;
		if (fragsize > free_blocks)
			fragsize = free_blocks;
		blocks_left -= fragsize;
		if (!blocks_left)
			flags |= RT11FFS_DIRENT_LAST;
		sizefield = flags | fragsize;
		bcopy(filename, dirent_ptr, 6);
		dirent_ptr += 3;
		*dirent_ptr++ = htons(sizefield);
		dirents_left--;
		read(fd, datablk_ptr, fragsize * RT11FFS_AU_SIZE);
		datablk_ptr += fragsize * RT11FFS_AU_SIZE;
		if (!blocks_left && pad)
			bzero(datablk_ptr - pad, pad);
		free_blocks -= fragsize;
		if (!free_blocks)
			flush_segment();
		flags &= ~RT11FFS_DIRENT_FIRST;
	}
	close(fd);
}

start_segment()
{
	bcopy(&segment_header, segbuf, sizeof segment_header);
	dirent_ptr = (u_short *)(segbuf + sizeof segment_header);
	memset(dirent_ptr, 0xFF, segment_size - sizeof segment_header);
	dirents_left = 63;
	datablk_ptr = segbuf + RT11FFS_AU_SIZE;
	free_blocks = segment_size / RT11FFS_AU_SIZE - 1;
	segment_going = 1;
}

flush_segment()
{
	write(1, segbuf, segment_size);
	segment_going = 0;
}

ispowerof2(n)
	u_long n;
{
	return(count1s(n) == 1);
}

count1s(n)
	u_long n;
{
	int c = 0;
	u_long mask;

	for (mask = 1; mask; mask <<= 1)
		if (n & mask)
			c++;
	return(c);
}
