#include <sys/param.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "../include/helpfile.h"

#define	MAXTOPICS	32

char *srcname;
FILE *srcfile;
int textbufsize;
char *textbuf, *textptr;
struct helpfile_index indexbuf[MAXTOPICS];
int indexcnt;
int opentopic, blankcnt;

char linebuf[128];
int lineno;

closetopic()
{
	textptr -= blankcnt;
	blankcnt = 0;
	*textptr++ = '\0';
	opentopic = 0;
}

process_line()
{
	char *cp;

	cp = index(linebuf, '\n');
	if (!cp) {
		fprintf(stderr, "%s: line %d: too long or unterminated\n",
			srcname, lineno);
		exit(1);
	}
	*cp = '\0';
	if (!strncmp(linebuf, "=== ", 4)) {
		if (opentopic)
			closetopic();
		strncpy(indexbuf[indexcnt].topic, linebuf + 4, 12);
		indexbuf[indexcnt].offset = htonl(sizeof(indexbuf) +
						(textptr - textbuf));
		indexcnt++;
		if (indexcnt >= MAXTOPICS) {
			fprintf(stderr, "%s: topic limit exceeded\n", srcname);
			exit(1);
		}
	} else if (!linebuf[0]) {
		if (!opentopic)
			return;
		*textptr++ = '\n';
		blankcnt++;
	} else {
		opentopic = 1;
		blankcnt = 0;
		sprintf(textptr, "%s\n", linebuf);
		textptr += strlen(linebuf) + 1;
	}
}

main(argc, argv)
	char **argv;
{
	if (argc != 3) {
		fprintf(stderr, "usage: %s srcfile hlpfile\n", argv[0]);
		exit(1);
	}
	open_src_file(argv[1]);
	srcname = argv[1];
	for (lineno = 1; fgets(linebuf, sizeof linebuf, srcfile); lineno++)
		process_line();
	if (opentopic)
		closetopic();
	indexbuf[indexcnt].offset = htonl(sizeof(indexbuf));
	emit_bin_output(argv[2]);
	exit(0);
}

open_src_file(filename)
	char *filename;
{
	struct stat st;

	srcfile = fopen(filename, "r");
	if (!srcfile) {
		perror(filename);
		exit(1);
	}
	fstat(fileno(srcfile), &st);
	textbufsize = st.st_size + 1;
	textbuf = malloc(textbufsize);
	if (!textbuf) {
		perror("malloc");
		exit(1);
	}
	textptr = textbuf;
}

emit_bin_output(filename)
	char *filename;
{
	int f;

	f = open(filename, O_WRONLY|O_CREAT|O_TRUNC, 0644);
	if (!f) {
		perror(filename);
		exit(1);
	}
	write(f, indexbuf, sizeof(indexbuf));
	write(f, textbuf, textptr - textbuf);
	close(f);
}
