#include "../libc/types.h"
#include "../include/mc68302.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/config.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/util.h"
#include "../lib8973/bpstate.h"
#include "../lib8973/timermac.h"
#include "state.h"

extern volatile struct mc68302_regs mc68302_regs;

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/

#define REBUILD_DAGC_TH         450
#define REBUILD_FFE_TH          140

void
tempenv_adapt_dagc_dfe(st, do_dfe)
	struct sdcore_state *st;
	int do_dfe;
{
	DECLARE_PTR;
	DECLARE_MODE_PTR;
	u_char dagc_old[2], dagc_new[2];
	u_short old_value, new_value;
	u_short saved_imr;

	bp_eq_read(DAGC_HIGH, dagc_old);
	old_value = BYTE2WORD(dagc_old[1], dagc_old[0]);

	saved_imr = mc68302_regs.imr;
	mc68302_regs.imr &= ~st->tempenv_critsect_irqmask;
	BP_WRITE_BIT(bp_mode_ptr, dagc_modes, adapt_coefficient, ON);
	if (do_dfe)
		BP_WRITE_BIT(bp_mode_ptr, dfe_modes, adapt_coefficients, ON);
	SET_WORD(bp_ptr, t3_low, t3_high, 500);
	RESTART_T3;
	WAIT_FOR_TIMER(TIMERMASK_T3);
	BP_WRITE_BIT(bp_mode_ptr, dagc_modes, adapt_coefficient, OFF);
	if (do_dfe)
		BP_WRITE_BIT(bp_mode_ptr, dfe_modes, adapt_coefficients, OFF);
	mc68302_regs.imr = saved_imr;

	bp_eq_read(DAGC_HIGH, dagc_new);
	new_value = BYTE2WORD(dagc_new[1], dagc_new[0]);
	if (abs(new_value - old_value) > REBUILD_DAGC_TH)
		bp_eq_write(DAGC_HIGH, dagc_old);
}

/*-------------------------------------------------------*/
/* HTU-C Only, adapt FFE                                 */
/* First store away FFE Coefs, then after adapting       */
/* check to see if FFE Coefs changed drastically.  If so */
/* assume a micro-interruption on the line occured       */
/* then recall previous known good FFE Coef valus.       */
/*-------------------------------------------------------*/
void
tempenv_adapt_ffe(st)
	struct sdcore_state *st;
{
	DECLARE_PTR;
	DECLARE_MODE_PTR;
	u_short saved_imr;
	u_char buf[2];
	u_short saved_ffe_coeffs[8], value;
	int i;

	for (i = 0; i < 8; i++) {
		bp_eq_read(i, buf);
		saved_ffe_coeffs[i] = BYTE2WORD(buf[1], buf[0]);
	}

	saved_imr = mc68302_regs.imr;
	mc68302_regs.imr &= ~st->tempenv_critsect_irqmask;
	BP_WRITE_BIT(bp_mode_ptr, ffe_modes, adapt_coefficients, ON);
	SET_WORD(bp_ptr, t3_low, t3_high, 500);
	RESTART_T3;
	WAIT_FOR_TIMER(TIMERMASK_T3);
	BP_WRITE_BIT(bp_mode_ptr, ffe_modes, adapt_coefficients, OFF);
	mc68302_regs.imr = saved_imr;

	/* keep the new or restore the old? */
	bp_eq_read(5, buf);
	value = BYTE2WORD(buf[1], buf[0]);
	if (abs(value - saved_ffe_coeffs[5]) >= REBUILD_FFE_TH)
		goto restore;
	bp_eq_read(6, buf);
	value = BYTE2WORD(buf[1], buf[0]);
	if (abs(value - saved_ffe_coeffs[6]) >= REBUILD_FFE_TH)
		goto restore;
	bp_eq_read(4, buf);
	value = BYTE2WORD(buf[1], buf[0]);
	if (abs(value - saved_ffe_coeffs[4]) >= REBUILD_FFE_TH)
		goto restore;
	/* keep the new */
	return;

restore:
	for (i = 0; i < 8; i++) {
		buf[0] = LOW(saved_ffe_coeffs[i]);
		buf[1] = HIGH(saved_ffe_coeffs[i]);
		bp_eq_write(i, buf);
	}
}
