/*  HTU_C & HTU_R operational stages */
#define IDLE                           0
#define ACTIVATE_SYSTEM                1
#define DC_CANCELLATION                2
#define INIT_STARTUP                   3
#define ADAPT_EC_STAGE1                4
#define ADAPT_EC_STAGE2                5
#define ADAPT_EC_STAGE3                6
#define WAIT_FOR_SIGNAL                7
#define AAGC1                          8
#define AAGC2                          9
#define AAGC3                         10
#define ADAPT_EC_AFTER_AAGC1          11
#define ADAPT_EC_AFTER_AAGC2          12
#define ADAPT_EC_AFTER_AAGC3          13
#define ADAPT_EC_AFTER_AAGC4          14
#define REMOTE_PHASE_LOCK             15
#define TIPRING1                      16
#define TIPRING2                      17
#define WAIT_FOR_REMOTE_PHASE_LOCK    18
#define START_OPEN_EYE                19
#define PHASE_ADAPT_EC1               20
#define PHASE_ADAPT_EC2               21
#define PHASE_ADAPT_EC3               22
#define PHASE_ADAPT_EC4               23
#define OPEN_EYE1                     24
#define OPEN_EYE2                     25
#define OPEN_EYE3                     26
#define OPEN_EYE4                     27
#define OPEN_EYE5                     28
#define OPEN_EYE6                     29
#define OPEN_EYE7                     30
#define TIPRING3                      31

/* 
 * Added in Bt8960/70/73 V4.0 
 * CALC_OPT_PHASEn only used by HTU-C
 * ACQUIRE_FREQn only used by HTU-R
 * therefore can share stage #
 */
#define CALC_OPT_PHASE2               32
#define CALC_OPT_PHASE3               33
#define CALC_OPT_PHASE4               34
#define CALC_OPT_PHASE                35

#define ACQUIRE_FREQ1                 32
#define ACQUIRE_FREQ2                 33
#define ACQUIRE_FREQ3                 34
#define ACQUIRE_FREQ4                 35

#define ACQUIRE_FREQ5                 36
#define PHASE_LOCKED                  37
#define OPTIMAL_PHASE                 38
#define TRANSMIT_2LEVEL               39
#define ADAPT_EC1                     40
#define ADAPT_EC2                     41
#define ADAPT_EC3                     42
#define OPEN_EYE_AT_OPTIMAL_PHASE1    43
#define OPEN_EYE_AT_OPTIMAL_PHASE2    44
#define OPEN_EYE_AT_OPTIMAL_PHASE3    45
#define OPEN_EYE_AT_OPTIMAL_PHASE4    46
#define OPEN_EYE_AT_OPTIMAL_PHASE5    47
#define ADAPT_DAGC_AFTER_AAGC         48
#define ADAPT_EQ1                     49
#define ADAPT_EQ2                     50
#define ADAPT_EQ3                     51
#define WAIT_FOR_T1MIN                52
#define TRANSMIT_4LEVEL               53
#define WAIT_FOR_4LEVEL               54
#define ADAPT_MODULES1                55
#define ADAPT_MODULES2                56
#define SET_NORMAL_CONDITIONS         57
#define NORMAL_OPERATION              58
#define DEACTIVATE_MODE               60
#define OPEN_EYE_AT_OPTIMAL_PHASE6    61
#define OPEN_EYE_AT_OPTIMAL_PHASE7    62
#define OPEN_EYE_AT_OPTIMAL_PHASE8    63
#define OPEN_EYE_AT_OPTIMAL_PHASE9    64
#define OPEN_EYE_AT_OPTIMAL_PHASE10   65
#define OPEN_EYE_AT_OPTIMAL_PHASE11   66
#define OPEN_EYE_AT_OPTIMAL_PHASE12   67
#define OPEN_EYE_AT_OPTIMAL_PHASE13   68
#define OPEN_EYE_AT_OPTIMAL_PHASE14   69
#define WAIT_FOR_4LEVEL_2             70

/* Added in Bt8970 V3.0 */
#define WAIT_FOR_4LEVEL3              71
#define ADJUST_FELM_HIGH_TH           72
#define GOTO_WAIT_FOR_SIGNAL          73
#define START_OPEN_EYE2               74
#define SET_LOS_THRESHOLD             75
#define SU_WAIT_METER_INTERVAL1       76
#define SU_WAIT_METER_INTERVAL2       77

/* SDCORE pre-activation additions */
#define	PREACTIVATE_SYSTEM		80
#define	PREACT_DC_CANCEL		81
#define	CM_MULTWAIT0			82
#define	CM_MULTWAIT1			83
#define	CM_MULTWAIT2			84
#define	CM_MULTWAIT3			85
#define	CM_PULSE1			86
#define	CM_PULSE2			87
#define	CM_PAUSE1			88
#define	CM_PAUSE2			89
#define	CM_BABBLE0			90
#define	CM_BABBLE1			91
#define	CM_BABBLE2			92
#define	PREACT_RESTART			93
#define	PREACT_WAIT_FOR_LOS		94
#define	CM_PREACT_TX			95
/* AutoBaud implementation */
#define	STUC_AB_HELLO			100
#define	STUC_AB_HELLO_T			101
#define	STUC_AB_HELLO_W			102
#define	STUC_AB_HELLO_F			103
#define	STUC_AB_HELLO2			104
#define	STUC_AB_HELLO2_T		105
#define	STUC_AB_HELLO2_W		106
#define	STUC_AB_HELLO2_F		107
#define	STUC_AB_SETRATE			108
#define	STUC_AB_SETRATE_T		109
#define	STUC_AB_SETRATE_W		110
#define	STUC_AB_SETRATE_F		111
/* overlapping assignments for STU-R */
#define	STUR_AB_INITIAL			100
#define	STUR_AB_ENGAGED			101
#define	STUR_AB_PROC_IFCTF		102
#define	STUR_AB_PROC_CNX		103
#define	STUR_AB_RESP			104
#define	STUR_AB_PROBE_WAITC		105
#define	STUR_AB_PROBE_WAITR		106
