#include "../libc/types.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/config.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/util.h"
#include "../lib8973/bpstate.h"
#include "../lib8973/timermac.h"
#include "state.h"
#include "privstate.h"
#include "miscmac.h"

/***********************************************************/
/*    _SetActvationInterval()                              */
/*    This function sets the Activation Interval Timeout   */
/*    value into SUT4 based on the _ACTIVATION_TIMEOUT     */
/*    setting.                                             */
/*                                                         */
/*    returns: none                                        */
/*                                                         */
/*    Input variables: BP_U_8BIT no;                       */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*                                                         */
/* Programmer:                                             */
/*     Dean Rasmussen             10-Jun-1998              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/
void
_SetActivationInterval(st)
	struct state *st;
{
    DECLARE_PTR;
    DECLARE_MODE_PTR;
    BP_U_16BIT temp_u16, sym_rate;
    BP_U_8BIT temp;

    sym_rate = BP_global_state.symbol_rate;

    /* SUT4 = (48 * sym_rate + 8192) */
    temp_u16 = SYMRATE_DECBIN_ADJUST((sym_rate << 5) + (sym_rate << 4)) + 8192;

    SET_WORD(bp_ptr, sut4_low, sut4_high, temp_u16);
    RESTART_SUT4;
    bp_mode_ptr->mask_low_reg.sut4 = 0;
}
