#include "../libc/types.h"
#include "../lib8973/bpstate.h"
#include "state.h"
#include "privstate.h"
#include "stages.h"
#include "miscmac.h"

extern void	_BtReset();
extern void	_BtInitialize();
extern void	bp_power_down();

void
btreset_wrap(st)
	struct sdcore_state *st;
{
	DECLARE_PST;

	_BtReset(0);
	pst->stage = IDLE;
	st->status.byte = INIT_STATUS_REG;
}

void
btreset_setbclk(st, rate)
	struct sdcore_state *st;
	int rate;
{
	DECLARE_PST;

	BP_global_state.symbol_rate = rate;
	_BtReset(0);
	pst->stage = IDLE;
	st->status.byte = INIT_STATUS_REG;
}

void
btinit_wrap(st)
	struct sdcore_state *st;
{
	DECLARE_PST;

	_BtInitialize(0);
	pst->stage = IDLE;
	st->status.byte = INIT_STATUS_REG;
}

void
powerdown_wrap(st)
	struct sdcore_state *st;
{
	DECLARE_PST;

	bp_power_down();
	pst->stage = IDLE;
	st->status.byte = INIT_STATUS_REG;
}
