#include "../libc/types.h"
#include "state.h"
#include "privstate.h"

/***********************************************************/
/*    _BtMain()                                            */
/*    Bitpump main routine.                                */
/*                                                         */
/*    Returns: void                                        */
/*                                                         */
/*    Input Variables: None                                */
/*                                                         */
/*    Output Variables: None                               */
/*                                                         */
/*    example:                                             */
/*           _BtMain();                                    */
/*                                                         */
/* programer:                                              */
/*     Iris Shuker                24-Oct-1993              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

void
_BtMain(st)
	struct sdcore_state *st;
{
	DECLARE_PST;

	/*---------------------------------------------*/
	/* Process micro processor interrupts          */
	/*---------------------------------------------*/
	_HandleFlags(st); /* Handle bit_pump received interrpts flags */

	/*---------------------------------------------*/
	/* Execute HTU-C or HTU-R Control Process      */
	/*---------------------------------------------*/
	if (pst->terminal_type)	/* HTU-R */
		_HturControlProcess(st); /* HTU-R control process */
	else			/* HTU-C */
		_HtucControlProcess(st); /* HTU-C control_process */

} /* END _BtMain() */
