#include "../libc/types.h"
#include "api.h"
#include "state.h"
#include "privstate.h"

extern int	sdcore_init_state();
extern void	_BtMain();
extern int	sdcore_activate();
extern int	sdcore_deactivate();
extern void	btreset_wrap();
extern void	btinit_wrap();
extern void	powerdown_wrap();
extern int	is_datarate_supported();
extern u_short	bp_read_meter();
extern int	bp_read_felm();
extern char	_ReadNmr();
extern int	bp_set_rxmode();
extern int	bp_set_tx();
extern void	btreset_setbclk();

const struct sdcore_api sdcore_api_table
	__attribute__ ((section (".rodata")))
	= {
	/* ID fields */
	SDCORE_MAGIC,
	SDCORE_HWTYPE,
	SDCORE_APIVER,
	sizeof(struct sdcore_api),
	sizeof(struct sdcore_state),
	sizeof(struct privstate),
	/* function pointers */
	sdcore_init_state,
	_BtMain,
	sdcore_activate,
	sdcore_deactivate,
	btreset_wrap,
	btinit_wrap,
	powerdown_wrap,
	is_datarate_supported,
	bp_read_meter,
	bp_read_felm,
	_ReadNmr,
	bp_set_rxmode,
	bp_set_tx,
	btreset_setbclk
};
