/*
 * SDCORE API table structure
 */

struct sdcore_api {
	/* ID fields */
	u_long	sdcore_magic;
	u_long	sdcore_hwtype;
	u_long	sdcore_api_ver;
	u_long	sizeof_apitable;
	u_long	sizeof_state;
	u_long	sizeof_privstate;
	/* function pointers */
	int	(*swinit)();
	void	(*sdcore_main)();
	int	(*activate)();
	int	(*deactivate)();
	void	(*btreset)();
	void	(*btinit)();
	void	(*powerdown)();
	int	(*datarate_issup)();
	u_short	(*read_meter)();
	int	(*read_felm)();
	char	(*read_nmr)();
	int	(*set_rxmode)();
	int	(*set_tx)();
	void	(*set_bclk)();
};

#define	SDCORE_MAGIC	0x7F53442A
#define	SDCORE_HWTYPE	0x4D53494E
#define	SDCORE_APIVER	4
