#include "../libc/types.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/config.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/util.h"
#include "state.h"
#include "privstate.h"
#include "stages.h"
#include "miscmac.h"

#define DC_TAP_BT8970             119
#define DC_TAP_BT8960             60

sdcore_activate(st)
	struct sdcore_state *st;
{
	DECLARE_PST;

	pst->terminal_type = st->terminal_type;
	pst->stage = PREACTIVATE_SYSTEM;
	st->status.byte = INIT_STATUS_REG;
	return(0);
}

sdcore_deactivate(st)
	struct sdcore_state *st;
{
	DECLARE_PST;
	DECLARE_PTR;
	DECLARE_MODE_PTR;
	int dctap;
	u_char data[4];

        BP_WRITE_BIT(bp_mode_ptr, linear_ec_modes, adapt_coefficients, OFF); /* Freeze linear EC output */

	switch (GET_BITPUMP_TYPE()) {
	case BT8960:
		dctap = DC_TAP_BT8960;
		break;
	case BT8970:
	case RS8973:
		dctap = DC_TAP_BT8970;
		break;
	}
	bp_lec_read(dctap, data);

        SET_RESET(bp_mode_ptr, linear_ec_modes, zero_coefficients); /* Zero linear EC output */
        BP_WRITE_BIT(bp_mode_ptr, nonlinear_ec_modes, zero_output, ON); /* Zero non linear EC output */
	bp_lec_write(dctap, data);

        BP_WRITE_BIT(bp_mode_ptr, transmitter_modes, transmitter_off, ON); /* Set transmitter OFF */

        st->status.bits.four_level_indication = OFF;
        st->status.bits.normal_operation = OFF;
        st->status.bits.tip_ring_indication = 0;

	bp_ptr->irq_source = ~IRQMASK_LOWFELM;
        BP_WRITE_BIT(bp_mode_ptr, mask_high_reg, low_felm, OFF); /* Remove low FELM interrupt mask */

	pst->stage = DEACTIVATE_MODE;
	return(0);
}
