#include "../libc/types.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/config.h"
#include "../lib8973/bitpump.h"
#include "state.h"
#include "privstate.h"
#include "../libpreact/autobaud.h"
#include "../libpreact/ifctf_preact.h"

evaluate_ab_response(st, msg)
	struct sdcore_state *st;
	union autobaud_msg *msg;
{
	printf("Got response: %08X\r\n", msg->word);
	if (st->preact_type == PREACT_TYPE_IFCTF &&
	    !ifctf_preact_checkcrc(msg)) {
		printf("Bad CRC\r\n");
		return(-1);
	}
	if (st->preact_type == PREACT_TYPE_AUTOBAUD &&
	    (msg->bytes[0] ^ msg->bytes[1] ^ msg->bytes[2] ^ msg->bytes[3])) {
		printf("Bad checksum\r\n");
		return(-1);
	}
	return(0);
}

ifctf_show_stur_type(st, code)
	struct sdcore_state *st;
	int code;
{
	char *str, strbuf[16];

	switch (code) {
	case IPA_RTYPE_FULLTERM:
		str = "Full terminal";
		break;
	case IPA_RTYPE_DSU:
		str = "DSU";
		break;
	case IPA_RTYPE_DSU_DTEDOWN:
		str = "DSU (attached DTE is down)";
		break;
	case IPA_RTYPE_REG:
		str = "Repeater";
		break;
	default:
		sprintf(strbuf, "%02X (unknown)", code);
		str = strbuf;
	}
	printf("STU-R device class is %s\r\n", str);
}

evaluate_ifctf_ack(st, msg)
	struct sdcore_state *st;
	union autobaud_msg *msg;
{
	switch (msg->bytes[0]) {
	case IPA_OPC_ACK:
		printf("Good ACK\r\n");
		return(0);
	case IPA_OPC_NAK:
		ifctf_show_stur_nak(st, msg);
		return(-1);
	default:
		printf("Unexpected response opcode\r\n");
		return(-1);
	}
}

ifctf_show_stur_nak(st, msg)
	struct sdcore_state *st;
	union autobaud_msg *msg;
{
	char *str, strbuf[16];

	switch (msg->bytes[2]) {
	case IPA_NAK_UNKNOWN:
		str = "Request not understood";
		break;
	case IPA_NAK_UNIMPL:
		str = "Unimplemented";
		break;
	case IPA_NAK_HWLIMIT:
		str = "Hardware limitation";
		break;
	case IPA_NAK_PROTVIO:
		str = "Protocol violation";
		break;
	default:
		sprintf(strbuf, "%02X (unknown)", msg->bytes[2]);
		str = strbuf;
	}
	printf("STU-R NAK code: %s\r\n", str);
}

default_cnxab_response(st)
	struct sdcore_state *st;
{
	u_char	byte1, byte2;
	char *s;

	byte1 = st->cnxab_htuc_flavor[0];
	byte2 = st->cnxab_htuc_flavor[1];
	printf("HTU-C indicates AutoBaud version %d %s Post\r\n", byte1 >> 6,
		byte1 & 0x10 ? "with" : "without");
	byte1 &= 0x0F;
	switch (byte1) {
	case 0x00:
		s = "B";
		break;
	case 0x01:
		s = "A";
		break;
	case 0x04:
		s = "HB";
		break;
	case 0x05:
		s = "HA";
		break;
	case 0x06:
		s = "T1/E1";
		break;
	case 0x09:
		s = "ATM over CAP";
		break;
	default:
		s = "unknown";
	}
	printf("Indicated flavor: %s\r\n", s);
	switch (byte1) {
	case 0x00:
		if (byte2 & 0x08) {
			printf("HTU-C indicates non-ANSI bit order: assuming magnitude first\r\n");
			st->quat_orient = _SERIAL_MAGFIRST;
		} else {
			printf("HTU-C indicates ANSI bit order: assuming sign first\r\n");
			st->quat_orient = _SERIAL_SIGNFIRST;
		}
		printf("HTU-C indicates %d-bit CRC, %s CMCP, %s ILMI\r\n",
			byte2 & 0x04 ? 32 : 16, byte2 & 0x02 ? "with" : "no",
			byte2 & 0x01 ? "with" : "no");
		break;
	case 0x01:
	case 0x09:
		switch (byte2 & 0x03) {
		case 0x00:
			s = "no";
			break;
		case 0x01:
			s = "SSS";
			break;
		case 0x02:
			s = "DSS";
			break;
		case 0x03:
			s = "unknown";
		}
		printf("HTU-C indicates %s scrambling, %s coset, %s ILMI\r\n",
			s, byte2 & 0x04 ? "with" : "no",
			byte2 & 0x08 ? "with" : "no");
		/* FALL THRU */
	default:
		printf("Assuming sign bit first\r\n");
		st->quat_orient = _SERIAL_SIGNFIRST;
	}
	st->cnxab_htur_flavor[0] = byte1;
	st->cnxab_htur_flavor[1] = byte2;
	return(0);
}
