#include "types.h"
#include "stdio.h"
#include "intr.h"
#include "gpio.h"
#include "param.h"

extern caddr_t m68000_vectors[];

extern caddr_t malloc();

caddr_t buffers;
int scc_running;
caddr_t saved_timer1_vec;

mymain()
{
	int c;

	buffers = malloc(BUFALLOC);
	printf("SCC2 dump utility running, buffers at %08X\r\n", buffers);
	scc_running = 0;
	saved_timer1_vec = m68000_vectors[INTVEC_TIMER1];
	display_help();
	for (;;) {
		c = getchar_poll();
		if (c != EOF) {
			if (c == 'Q' || c == 'q')
				break;
			else
				do_command(c);
		}
		switch (scc_running) {
		case 1:
			hdlc_rx_proc();
			break;
		case 2:
			capture_proc();
			break;
		case 3:
			fmeter_proc();
			break;
		}
	}
	scc_stop();
	return(0);
}

display_help()
{
	printf("\r\nSingle-key commands:\r\n");
	printf("0: Show the state of modem control lines\r\n");
	printf("1: Toggle DSR\r\n");
	printf("2: Toggle CD\r\n");
	printf("3: Toggle CTS\r\n");
	printf("H: Receive and dump HDLC frames\r\n");
	printf("C: One-shot bit stream capture\r\n");
	printf("F: CCITT_113 clock frequency meter\r\n");
	printf("S: Stop the SCC\r\n");
	printf("Q: Quit the utility\r\n");
	return(0);
}

do_command(cmd)
	int cmd;
{
	switch (cmd) {
	case '0':
		show_mctl();
		return;
	case '1':
		toggle_mctl(PORTB_DSR, "DSR");
		return;
	case '2':
		toggle_mctl(PORTB_CD, "CD");
		return;
	case '3':
		toggle_mctl(PORTB_CTS, "CTS");
		return;
	case 'H':
	case 'h':
		setup_hdlcdump();
		return;
	case 'C':
	case 'c':
		setup_capture();
		return;
	case 'F':
	case 'f':
		setup_fmeter();
		return;
	case 'S':
	case 's':
		scc_stop();
		printf("SCC2 stopped\r\n");
		return;
	case 'T':
	case 't':
		asm("trap #0");
		return;
	default:
		display_help();
	}
}
