#include "types.h"
#include "stdio.h"
#include "mc68302.h"
#include "cp.h"
#include "intr.h"
#include "param.h"

extern caddr_t m68000_vectors[];
extern volatile struct mc68302_regs mc68302_regs;
extern volatile struct mc68302_scc_bd scc2_rx_bds[8];
extern volatile struct mc68302_scc_hdlcparams scc2_params;

extern caddr_t buffers;
extern int scc_running;
extern caddr_t saved_timer1_vec;

extern char _Xvec_timer;

int fmeter_50ms_count;

setup_fmeter()
{
	if (mc68302_regs.scc2.scm & (SCM_ENR|SCM_ENT) || scc_running) {
		printf("SCC2 is already running\r\n");
		return(0);
	}

	mc68302_regs.scc2.scm = SCM_SOFT_CTS_CD | SCM_BISYNC_EXSYN
				| SCM_BISYNC_NTSYN | SCM_MODE_BISYNC;
	scc2_rx_bds[0].bd_flags = 0xC000;
	scc2_rx_bds[0].bd_bufptr = buffers;
	scc2_rx_bds[1].bd_flags = 0;
	scc2_rx_bds[2].bd_flags = 0;
	scc2_rx_bds[3].bd_flags = 0;
	scc2_rx_bds[4].bd_flags = 0;
	scc2_rx_bds[5].bd_flags = 0;
	scc2_rx_bds[6].bd_flags = 0;
	scc2_rx_bds[7].bd_flags = 0x2000;
	scc2_params.rfcr = 0x50;
	scc2_params.tfcr = 0x50;
	scc2_params.mrblr = METERCAP;
	scc2_params.rbdn = 0;
	scc_running = 3;
	printf("Set up to capture %u bytes\r\n", METERCAP);
	fmeter_50ms_count = -1;
	m68000_vectors[INTVEC_TIMER1] = &_Xvec_timer;
	return(0);
}

fmeter_proc()
{
	volatile struct mc68302_scc_bd *bd;
	u_short flags, tcn;
	unsigned ms;

	bd = scc2_rx_bds;
	flags = bd->bd_flags;
	if (flags & 0x8000)
		return;
	spl4();
	tcn = mc68302_regs.timer1.tcn;
	m68000_vectors[INTVEC_TIMER1] = saved_timer1_vec;
	spl0();
	scc_stop();
	ms = fmeter_50ms_count * 50 + (unsigned) tcn * 5 / 4608;
	printf("Received %u bytes in %u ms\r\n", METERCAP, ms);
	printf("CCITT_113 must be ticking around %u kbps\r\n",
		METERCAP * 8 / ms);
}
