/*
 * Standard craft terminal commands
 */

#include "types.h"
#include "ctype.h"
#include "stdio.h"
#include "strings.h"
#include "mc68302.h"
#include "gpio.h"
#include "monitor_api.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"
#include "../lib8973/readmeter.h"
#include "../lib8973/readfelm.h"

extern volatile struct mc68302_regs mc68302_regs;

extern struct sdcore_api *sdcore_api;
extern struct sdcore_state *sdcore_state;
extern u_short help_filename[3];

extern void cmd_show();
extern void config_dump();
extern void reboot();

cmd_help(arg)
	char *arg;
{
	char *cp, *np;

	for (cp = arg; isspace(*cp); cp++)
		;
	if (!*cp) {
		monapi_help(help_filename, "");
		return;
	}
	for (np = cp; *cp && !isspace(*cp); cp++)
		;
	if (*cp)
		*cp++ = '\0';
	monapi_help(help_filename, np);
}

cmd_show_line()
{
	int up;
	u_short value;
	short svalue;
	struct felmdata fd;
	int num, minus;

	up = sdcore_state->status.bits.normal_operation &&
		!sdcore_state->status.bits.los;
	printf("SDSL/2B1Q link is %s\r\n", up ? "UP" : "DOWN");
	if (!up)
		return(0);
	value = sdcore_api->read_meter(sdcore_state, READMETER_AAGC);
	printf("AAGC: %d dB\r\n", value * 3);
	value = sdcore_api->read_meter(sdcore_state, READMETER_DCOFFSET);
	svalue = (short) value;
	printf("DC adjustment: %d\r\n", svalue);
	value = sdcore_api->read_meter(sdcore_state, READMETER_SLM_NORM);
	printf("SLM: %u\r\n", value);
	sdcore_api->read_felm(sdcore_state, &fd);
	printf("FELM: %u\r\n", fd.norm_felm);
	printf("Attenuation: %d dB\r\n", fd.db_atten);
	num = sdcore_api->read_nmr(sdcore_state);
	if (num < 0) {
		num = -num;
		minus = 1;
	} else
		minus = 0;
	printf("NMR: %s%u.%c dB\r\n", minus ? "-" : "", num >> 1,
		num & 1 ? '5' : '0');
	value = sdcore_api->read_meter(sdcore_state, READMETER_VCXO);
	svalue = (short) value;
	printf("Frequency offset: %d\r\n", svalue);
	printf("Tip/ring polarity: %s\r\n",
		sdcore_state->status.bits.tip_ring_indication
		? "reversed" : "correct");
	return(0);
}

cmd_show_mctl()
{
	printf("DTR is %s\r\n", mc68302_regs.pbdat & PORTB_DTR ?
		"asserted" : "negated");
	printf("DSR is %s\r\n", mc68302_regs.pbdat & PORTB_DSR ?
		"asserted" : "negated");
	printf("CD is %s\r\n", mc68302_regs.pbdat & PORTB_CD ?
		"asserted" : "negated");
	printf("RTS is %s\r\n", mc68302_regs.pbdat & PORTB_RTS ?
		"asserted" : "negated");
	printf("CTS is %s\r\n", mc68302_regs.pbdat & PORTB_CTS ?
		"asserted" : "negated");
	return(0);
}

cmd_trap()
{
	asm("trap #0");
}

register_standard_commands()
{
	register_craft_command("HELP", 4, cmd_help);
	register_craft_command("SHOW", 4, cmd_show);
	register_craft_command("RESET", 5, monapi_reset);
	register_craft_command("REBOOT", 6, reboot);
	register_craft_command("TRAP", 4, cmd_trap);
	register_show_subcmd("CONFIG", 4, config_dump);
	register_show_subcmd("LINE", 4, cmd_show_line);
	register_show_subcmd("MCTL", 4, cmd_show_mctl);
	return(0);
}
