/*
 * This code handles the configuration of low-level tunable parameters
 * which are otherwise treated as boilerplate and deprived of attention.
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "monitor_api.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"

extern struct sdcore_api *sdcore_api;
extern struct sdcore_state *sdcore_state;

extern char *config_search();

static
get_htuc_extradelays()
{
	char *s;
	int bool;

	s = config_search("htuc_extra_delays");
	if (!s)
		return(0);
	bool = parse_boolean_param(s);
	if (bool < 0) {
		printf("Error: htuc_extra_delays=%s: invalid setting\r\n", s);
		return(-1);
	}
	if (bool)
		sdcore_state->special_modes |= SDCORE_MODE_HTUC_EXTRADELAYS;
	return(0);
}

static
get_lost_time()
{
	char *s;
	int val;

	s = config_search("lost_time");
	if (!s)
		return(0);
	if (!is_string_num(s)) {
		printf("Error: lost_time=%s: invalid setting\r\n", s);
		return(-1);
	}
	val = atoi(s);
	sdcore_state->lost_time = val;
	return(0);
}

static
get_nlec_on()
{
	char *s;
	int bool;

	s = config_search("nlec_on");
	if (!s)
		return(0);
	bool = parse_boolean_param(s);
	if (bool < 0) {
		printf("Error: nlec_on=%s: invalid setting\r\n", s);
		return(-1);
	}
	if (bool)
		sdcore_state->special_modes |= SDCORE_MODE_NLECON;
	return(0);
}

static
get_tempenv_intervals()
{
	char *s;
	int val;

	s = config_search("tempenv_intervals");
	if (!s)
		return(0);
	if (!is_string_num(s)) {
		printf("Error: tempenv_intervals=%s: invalid setting\r\n", s);
		return(-1);
	}
	val = atoi(s);
	sdcore_state->tempenv_num_intervals = val;
	return(0);
}

static
get_txgain()
{
	char *s, *cp;
	int minus = 0, val;

	s = config_search("tx_gain");
	if (!s)
		return(0);
	cp = s;
	if (*cp == '-') {
		minus = 1;
		cp++;
	} else if (*cp == '+')
		cp++;
	if (!isdigit(*cp)) {
inv:		printf("Error: tx_gain=%s: invalid setting\r\n", s);
		return(-1);
	}
	val = *cp++ - '0';
	if (*cp)
		goto inv;
	if (val > (minus ? 8 : 7))
		goto inv;
	if (minus)
		val = -val;
	sdcore_state->txgain_setting = val;
	sdcore_state->special_modes |= SDCORE_MODE_TXGAIN_OVERRIDE;
	return(0);
}

get_lltune_params()
{
	get_htuc_extradelays();
	get_lost_time();
	get_nlec_on();
	get_tempenv_intervals();
	get_txgain();
	return(0);
}
