#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"

extern u_long last_memacc_addr;
extern u_short last_memacc_size;

cmd_deposit(cmd)
	char *cmd;
{
	struct param params[256], *datum;
	struct datactl datactl;
	char *addrtext;
	int addrlen;
	u_long addr;
	char *qp = NULL;

	bzero(params, sizeof(params));
	bzero(&datactl, sizeof(datactl));
	if (parse_cmd(cmd, 2, 256, params, &datactl, NULL, NULL))
		return(0);
	addrtext = params[0].text;
	addrlen = params[0].len;
	if (parse_addr(addrtext, addrlen, &datactl, &addr))
		return(0);
	if (params[2].text && datactl.count) {
		error("Qualifier conflict");
		return(0);
	}
	for (datum = &params[1]; datum->text; datum++) {
		u_long num;
		int stat;

		if (check_intr())
			return(0);
		switch (datactl.datasize) {
		case DATASIZE_BYTE:
			if (qp) {
				if (*qp == '\"') {
					qp = NULL;
					continue;
				}
				stat = deposit_byte(addr, *qp);
				qp++;
				datum--;
				break;
			}
			if (datum->text[0] == '\"') {
				if (datactl.count) {
					error("Qualifier conflict");
					return;
				}
				qp = datum->text + 1;
				datum--;
				continue;
			} else if (parse_hexnum(datum->text, datum->len, &num))
				return(0);
			if (num & 0xFFFFFF00) {
				error("Value too large");
				return(0);
			}
			stat = deposit_byte(addr, num);
			break;
		case DATASIZE_WORD:
			if (parse_hexnum(datum->text, datum->len, &num))
				return(0);
			if (num & 0xFFFF0000) {
				error("Value too large");
				return(0);
			}
			stat = deposit_word(addr, num);
			break;
		case DATASIZE_LONG:
			if (parse_hexnum(datum->text, datum->len, &num))
				return(0);
			stat = deposit_long(addr, num);
			break;
		}
		if (stat)
			break;
		last_memacc_addr = addr;
		last_memacc_size = datactl.datasize;
		addr += datactl.step;
		if (datactl.count) {
			datum--;
			datactl.count--;
		}
	}
	return(0);
}

deposit_byte(addr, val)
	u_long addr;
	u_char val;
{
	*(u_char *)addr = val;
	return(0);
}

deposit_word(addr, val)
	u_long addr;
	u_short val;
{
	if (addr & 1) {
		error("Odd address");
		return(1);
	}
	*(u_short *)addr = val;
	return(0);
}

deposit_long(addr, val)
	u_long addr;
	u_long val;
{
	if (addr & 1) {
		error("Odd address");
		return(1);
	}
	*(u_long *)addr = val;
	return(0);
}

cmd_examine(cmd)
	char *cmd;
{
	struct param params[1];
	struct datactl datactl;
	char *addrtext;
	int addrlen;
	u_long addr;

	bzero(params, sizeof(params));
	bzero(&datactl, sizeof(datactl));
	if (parse_cmd(cmd, 0, 1, params, &datactl, NULL, NULL))
		return(0);
	addrtext = params[0].text;
	addrlen = params[0].len;
	/* If no address is specified, + is assumed. */
	if (addrtext == NULL) {
		addrtext = "+";
		addrlen = 1;
	}
	if (parse_addr(addrtext, addrlen, &datactl, &addr))
		return(0);
	do {
		int stat;
		u_char bval;
		u_short wval;
		u_long lval;

		if (check_intr())
			return(0);
		switch (datactl.datasize) {
		case DATASIZE_BYTE:
			stat = examine_byte(addr, &bval);
			break;
		case DATASIZE_WORD:
			stat = examine_word(addr, &wval);
			break;
		case DATASIZE_LONG:
			stat = examine_long(addr, &lval);
			break;
		}
		if (stat)
			break;
		switch (datactl.datasize) {
		case DATASIZE_BYTE:
			printf(" P %08X %02X\r\n", addr, (u_long) bval);
			break;
		case DATASIZE_WORD:
			printf(" P %08X %04X\r\n", addr, (u_long) wval);
			break;
		case DATASIZE_LONG:
			printf(" P %08X %08X\r\n", addr, lval);
			break;
		}
		last_memacc_addr = addr;
		last_memacc_size = datactl.datasize;
		addr += datactl.step;
	} while (datactl.count--);
	return(0);
}

examine_byte(addr, valptr)
	u_long addr;
	u_char *valptr;
{
	*valptr = *(u_char *)addr;
	return(0);
}

examine_word(addr, valptr)
	u_long addr;
	u_short *valptr;
{
	if (addr & 1) {
		error("Odd address");
		return(1);
	}
	*valptr = *(u_short *)addr;
	return(0);
}

examine_long(addr, valptr)
	u_long addr;
	u_long *valptr;
{
	if (addr & 1) {
		error("Odd address");
		return(1);
	}
	*valptr = *(u_long *)addr;
	return(0);
}

cmd_hexdump(cmd)
	char *cmd;
{
	struct param params[2];
	u_long start, count;
	u_char *cp, *end;
	int rem16;

	if (parse_cmd(cmd, 2, 2, params, NULL, NULL, NULL))
		return(0);
	if (parse_hexnum(params[0].text, params[0].len, &start))
		return(0);
	if (parse_hexnum(params[1].text, params[1].len, &count))
		return(0);
	end = (u_char *) start + count;
	start &= 0xFFFFFFF0;
	cp = (u_char *) start;

	for (; cp < end; cp++) {
		if (check_intr())
			return(0);
		rem16 = (u_long)cp & 0xF;
		if (!rem16)
			printf("%08X:", cp);
		printf("%s %02X", rem16 & 3 ? "" : " ", (u_long) *cp);
		if (rem16 == 15 || cp == (end - 1))
			printf("\r\n");
	}
	return(0);
}
