/*
 * A utility command to initialize the frame buffers in the NOKFTX FPGA
 * to something sane.
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "nokia.h"
#include "nokftx.h"

extern volatile struct nokftx_memblock FPGA_regs;

static
init_cell_buf(buf, fill_octet)
	struct nokftx_atmcell *buf;
{
	int i;

	*(u_long *)buf->cellhdr = 0x00000001;
	buf->hec_coset = 0x55;
	for (i = 0; i < 48; i++)
		buf->payload[i] = fill_octet;
}

static
init_frame_buf(buf, fill_octet)
	struct nokftx_frame *buf;
{
	int i;

	for (i = 0; i < 8; i++)
		init_cell_buf(&buf->cells[i], fill_octet);
	buf->trailer[0] = 0x00;
	buf->trailer[1] = 0xFF;
	buf->trailer[2] = 0x00;
	buf->trailer[3] = 0x00;
	buf->trailer[4] = 0x00;
	buf->trailer[5] = 0x00;
	buf->crc6 = 0;
	buf->sync_octet = NOKIA_SYNC_OCTET;
}

cmd_nokftx(cmd)
	char *cmd;
{
	struct param params[1];
	u_long fill_octet;

	bzero(params, sizeof params);
	if (parse_cmd(cmd, 0, 1, params, NULL, NULL, NULL))
		return(0);
	if (params[0].text) {
		if (parse_hexnum(params[0].text, params[0].len, &fill_octet))
			return(0);
		if (fill_octet & 0xFFFFFF00) {
			error("Value too large");
			return(0);
		}
	} else
		fill_octet = 0x6A;
	if (FPGA_regs.id_reg != NOKFTX_IDREG) {
		error("NOKFTX FPGA not found");
		return(0);
	}
	init_frame_buf(&FPGA_regs.buffers[0], fill_octet);
	init_frame_buf(&FPGA_regs.buffers[1], fill_octet);
	return(0);
}
