#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"

extern struct sdcore_api *sdcore_api;
extern struct sdcore_state sdcore_state;

extern u_short in_cksum();

cmd_activate(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	sdcore_api->activate(&sdcore_state);
	return(0);
}

cmd_deactivate(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	sdcore_api->deactivate(&sdcore_state);
	return(0);
}

cmd_exit(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	return(1);
}

cmd_insum(cmd)
	char *cmd;
{
	struct param params[2];
	u_long start, len;

	if (parse_cmd(cmd, 2, 2, params, NULL, NULL, NULL))
		return(0);
	if (parse_hexnum(params[0].text, params[0].len, &start))
		return(0);
	if (parse_hexnum(params[1].text, params[1].len, &len))
		return(0);
	if (len & 0xFFFE0000) {
		error("Value too large");
		return(0);
	}
	if (start & 1 || len & 1) {
		error("Both start address and length must be even");
		return(0);
	}
	printf("%04X\r\n", in_cksum(start, len >> 1));
	return(0);
}

cmd_reset(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	sdcore_api->btreset(&sdcore_state);
	return(0);
}

static const struct keyword rx_modes[] = {
	{"RAW", 1, SELECT_DETECTOR_OUTPUT},
	{"LOOPBACK", 1, SELECT_TRANSMITTER_INPUT},
	{"DESCRAMBLED", 1, SELECT_DESCRAMBLER_OUTPUT},
	{NULL, 0, -1}};

cmd_rx(cmd)
	char *cmd;
{
	struct param params[1];
	int code, ambig = 0;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	code = find_keyword(params[0].text, params[0].len, rx_modes, &ambig);
	if (code != -1)
		sdcore_api->set_rxmode(&sdcore_state, code);
	else {
		if (ambig)
			error("Ambiguous mode keyword");
		else
			error("Invalid mode keyword");
	}
	return(0);
}

static const struct keyword tx_modes[] = {
	{"2L1S", 1, SCRAMBLED_TWO_LEVEL_ONES},
	{"4L1S", 1, SCRAMBLED_FOUR_LEVEL_ONES},
	{"EXTERNAL", 1, SCRAMBLED_FOUR_LEVEL_DATA},
	{"LOOPBACK", 1, DETECTOR_LOOPBACK},
	{"RAW2", 4, UNSCRAMBLED_TWO_LEVEL_DATA},
	{"RAW4", 4, UNSCRAMBLED_FOUR_LEVEL_DATA},
	{"OFF", 1, -2},
	{NULL, 0, -1}};

cmd_tx(cmd)
	char *cmd;
{
	struct param params[1];
	int code, txen, ambig = 0;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	code = find_keyword(params[0].text, params[0].len, tx_modes, &ambig);
	if (code != -1) {
		if (code == -2) {
			txen = 0;
			code = 0;
		} else
			txen = 1;
		sdcore_api->set_tx(&sdcore_state, txen, code);
	} else {
		if (ambig)
			error("Ambiguous mode keyword");
		else
			error("Invalid mode keyword");
	}
	return(0);
}
