/*
 * Comes straight from the Hack-o-Rocket router, Nokia SDSL version,
 * modulo a little bugfix with trailing cells.
 *
 * The disgusting ugliness of turning outgoing AAL5 packets into Nokia frames
 * is to be found here.
 */

#include "types.h"
#include "param.h"
#include "globals.h"
#include "nokia.h"
#include "nokia_impl.h"

extern struct buffer *get_buffer_from_queue();

struct nokia_preptxf_buf txfb_pool[NFTX_BUFS];
struct nokia_preptxf_buf *txfb_freelist;

struct buffer *p2f_buffer_inprogress;
u_char *p2f_src_ptr, *p2f_src_endptr;
struct nokia_preptxf_buf *p2f_frame_inprogress;
int p2f_frame_fill;

extern struct nokia_frame_scc tx_idle_frame;
extern const u_char idle_cell_hdr[5];
extern const u_char crc6_table[256];

p2f_init()
{
	int i;

	txfb_freelist = NULL;
	for (i = 0; i < NFTX_BUFS; i++) {
		bcopy_words(tx_idle_frame.hdrbytes,
			    txfb_pool[i].frame.hdrbytes, 8);
		p2f_free_txfb(txfb_pool + i);
	}
	bzero(&nokia_preptxf_queue, sizeof nokia_preptxf_queue);
	p2f_buffer_inprogress = NULL;
	p2f_frame_inprogress = NULL;
}

p2f_free_txfb(txfb)
	struct nokia_preptxf_buf *txfb;
{
	u_short save_sr;

	asm volatile ("move.w %%sr,%0" : "=dm" (save_sr) : );
	asm volatile ("move.w #0x2700,%%sr" : : : "cc");
	txfb->txfb_next = txfb_freelist;
	txfb_freelist = txfb;
	asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
}

p2f_flush()
{
	struct nokia_preptxf_buf *txfb;

	if (p2f_buffer_inprogress) {
		l2conv_api->free_buffer(p2f_buffer_inprogress);
		p2f_buffer_inprogress = NULL;
	}
	if (p2f_frame_inprogress) {
		p2f_free_txfb(p2f_frame_inprogress);
		p2f_frame_inprogress = NULL;
	}
	while (txfb = (struct nokia_preptxf_buf *)
		get_buffer_from_queue(&nokia_preptxf_queue))
		p2f_free_txfb(txfb);
}

p2f_process()
{
	struct nokia_preptxf_buf *txfb;
	struct vc *vc;
	u_short save_sr;

	if (p2f_frame_inprogress)
		txfb = p2f_frame_inprogress;
	else {
		asm volatile ("move.w %%sr,%0" : "=dm" (save_sr) : );
		asm volatile ("move.w #0x2700,%%sr" : : : "cc");
		txfb = txfb_freelist;
		if (txfb)
			txfb_freelist = txfb->txfb_next;
		asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
		if (!txfb)
			return;
		p2f_frame_inprogress = txfb;
		p2f_frame_fill = 0;
	}
	if (!p2f_buffer_inprogress) {
		p2f_start_packet();
		if (!p2f_buffer_inprogress) {
			if (p2f_frame_fill && !nokia_preptxf_queue.q_count) {
				p2f_pad_idlecells();
				p2f_push_frame();
			}
			return;
		}
	}
	vc = p2f_buffer_inprogress->buf_vc;
	bcopy(p2f_src_ptr, txfb->frame.cells[p2f_frame_fill].payload, 48);
	p2f_src_ptr += 48;
	if (p2f_src_ptr < p2f_src_endptr)
		bcopy(vc->cellhdr_normal,
			txfb->frame.cells[p2f_frame_fill].cellhdr, 5);
	else {
		bcopy(vc->cellhdr_last,
			txfb->frame.cells[p2f_frame_fill].cellhdr, 5);
		l2conv_api->free_buffer(p2f_buffer_inprogress);
		p2f_buffer_inprogress = NULL;
	}
	p2f_frame_fill++;
	if (p2f_frame_fill == 8)
		p2f_push_frame();
	else if (!p2f_buffer_inprogress && !nokia_preptxf_queue.q_count) {
		p2f_pad_idlecells();
		p2f_push_frame();
	}
}

p2f_start_packet()
{
	struct buffer *buf;

	buf = get_buffer_from_queue(&atm_outgoing_queue);
	if (!buf)
		return(-1);
	p2f_buffer_inprogress = buf;
	p2f_src_ptr = buf->buf_dataspc + buf->buf_dataoff;
	p2f_src_endptr = p2f_src_ptr + buf->buf_datalen;
	return(0);
}

p2f_push_frame()
{
	struct nokia_preptxf_buf *txfb;
	u_char crc, *cp;
	int i;

	txfb = p2f_frame_inprogress;
	cp = (u_char *) &txfb->frame;
	for (i = 0, crc = 0; i < 430; i++)
		crc = crc6_table[crc ^ *cp++];
	txfb->frame.hdrbytes[6] = crc;
	p2f_frame_inprogress = NULL;
	put_buffer_on_queue(txfb, &nokia_preptxf_queue);
	stats.atm_tx_nokiaframes++;
}

p2f_pad_idlecells()
{
	struct nokia_preptxf_buf *txfb;
	int i;

	txfb = p2f_frame_inprogress;
	for (i = p2f_frame_fill; i < 8; i++)
		bcopy(idle_cell_hdr, txfb->frame.cells[i].cellhdr, 5);
}
