OUTPUT_ARCH(m68k)
__DYNAMIC = 0;
SECTIONS
{
  m68000_vectors = 0;
  /* ROM code: */
  .text  0x200000  :
  {
    *(.text)
    *(.rodata)
    *(.rodata1)
  }
  etext = .;
  /* Cannot have any initialized data */
  /DISCARD/  :
  {
    *(.data)
    *(.data1)
  }
  /* low memory globals */
  .lowmem  0x400  :
  {
    *(gds)
  }
  /* private monitor bss */
  .bss :
  {
    *(.bss)
    *(COMMON)
  }
  end = .;
  /* MC68302 on-chip block: */
  onchip_block 0x700000 :
  {
    /* user RAM */
    *(ocr)
    . = 0x400;
    scc1_rx_bds = .;
    . = 0x440;
    scc1_tx_bds = .;
    . = 0x480;
    scc1_params = .;
    . = 0x500;
    scc2_rx_bds = .;
    . = 0x540;
    scc2_tx_bds = .;
    . = 0x580;
    scc2_params = .;
    . = 0x600;
    scc3_rx_bds = .;
    . = 0x640;
    scc3_tx_bds = .;
    . = 0x67C;
    sdma_berr_channel = .;
    . = 0x680;
    scc3_params = .;
    . = 0x800;
    mc68302_regs = .;
  }
  Bitpump_regs    = 0x600000;
}
