/*
 * Miscellaneous assembly routines for the monitor
 */

#include "mc68302_asm.h"
#include "intr.h"

	.text

	.globl	copy_vectors_to_ram
copy_vectors_to_ram:
	movea.l	#start+8,%a0
	movea.l	#8,%a1
	moveq.l	#57,%d1
1:	move.l	(%a0)+,(%a1)+
	dbra	%d1,1b
	adda.l	#16,%a0
	adda.l	#16,%a1
	move.l	#191,%d1
1:	move.l	(%a0)+,(%a1)+
	dbra	%d1,1b
	rts

	.globl	read_usp
read_usp:
	move	%usp,%a0
	move.l	%a0,%d0
	rts

	.globl	write_usp
write_usp:
	move.l	4(%a7),%a0
	move	%a0,%usp
	rts

	.globl	_Xvec_swtimer
_Xvec_swtimer:
	addq.l	#1,timebase
	move.b	#0x02,TER1
	move.w	#INTMASK_TIMER1,ISR
	rte
