/*
 * Miscellaneos C routines for the monitor
 */

#include "types.h"
#include "stdio.h"
#include "mc68302.h"
#include "gpio.h"
#include "buserr.h"
#include "mon302.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"

extern volatile struct mc68302_regs mc68302_regs;
extern volatile short sdma_berr_channel;
extern volatile long timebase;

extern int in_cmd_script;
extern struct cmdscript_nestlevel cmd_script_stack[];

const u_short oper_cmd_filename[3] __attribute__ ((section (".rodata")))
	= {0x6045, 0x7080, CMD_DEFEXT};

operboot()
{
	struct find_file_results findstruct;
	int stat;
	long time;

	stat = ffs_find_file(oper_cmd_filename, &findstruct);
	if (stat != FIND_STAT_FOUND)
		return;
	printf("OPER.CMD script found in FFS, booting in 5 s, press ^C to abort\r\n");
	if (push_cmd_script(&findstruct) < 0)
		return;
	time = timebase;
	while (timebase - time < 100)
		if (check_intr())
			return;
}

montrap_set_ledmctl()
{
	u_short portb;

	portb = mc68302_regs.pbdat;
	/* negate all modem control signals */
	portb &= ~(PORTB_DSR | PORTB_CD | PORTB_CTS);
	/* light the red LED */
	portb |= PORTB_MISC7;
	mc68302_regs.pbdat = portb;
	/* line status LED off */
	mc68302_regs.padat &= ~PORTA_LSLED_MASK;
}

handle_sdma_buserr()
{
	int chan;

	chan = sdma_berr_channel;
	/* recover */
	mc68302_regs.cr = 0x81;		/* reset */
	cpu_delay_us(4);		/* 100 clocks should be enough */
	serial_init();
	/* report error */
	printf("\r\n?SDMA BERR: SCC%d %s\r\n", (chan >> 1) + 1,
		chan & 1 ? "Rx" : "Tx");
}

print_buserr_frame(frame)
	struct buserr_frame *frame;
{
	printf("PC=%08X  SR=%04X  IR=%04X\r\nAccess: %04X %08X\r\n", frame->pc,
		frame->sr, frame->ir, frame->acc_details, frame->acc_addr);
}

check_intr()
{
	int ch;

	ch = getchar_poll();
	switch (ch) {
	case 0x03:			/* ^C */
		printf("^C\r\n");
		in_cmd_script = 0;
		return(1);
	default:
		return(0);
	}
}

stop_cmd_script()
{
	in_cmd_script = 0;
}

setup_reinit_cmd()
{
	static const char cmd[] = "REINIT";

	cmd_script_stack[0].curptr = cmd;
	cmd_script_stack[0].endptr = cmd + 6;
	in_cmd_script = 1;
}
