/*
 * LOAD & RUN functionality
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "mon302.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"

extern u_long last_memacc_addr;
extern u_short last_memacc_size;

u_long last_load_addr;

ffs_find_file_wrapper(filename, findstruct)
	u_short *filename;
	struct find_file_results *findstruct;
{
	char filename_print[16];
	int stat;

	stat = ffs_find_file(filename, findstruct);
	switch (stat) {
	case FIND_STAT_FOUND:
		return(0);
	case FIND_STAT_NOTFOUND:
		rad50_filename_to_ascii_trimspaces(filename, filename_print);
		error("%s not found", filename_print);
		return(-1);
	case FIND_STAT_INVALID_DIR:
		error("RT11FFS appears to be corrupt");
		return(-1);
	case FIND_STAT_INVALID_FRAG:
		rad50_filename_to_ascii_trimspaces(filename, filename_print);
		error("%s: invalid fragmentation", filename_print);
		return(-1);
	}
}

load_from_ffs(filename, addr_override, loadaddr)
	u_short *filename;
	int addr_override;
	u_long loadaddr;
{
	char filename_print[16];
	struct find_file_results findstruct;
	struct program_header *hdr;
	struct fragment_info *fp;
	int i, fsize;
	u_char *dp;

	if (ffs_find_file_wrapper(filename, &findstruct) < 0)
		return(-1);
	if (!addr_override) {
		hdr = (struct program_header *) findstruct.frags[0].addr;
		if (hdr->magic != RUNABLE_PROGRAM_MAGIC) {
			rad50_filename_to_ascii_trimspaces(filename,
							   filename_print);
			error("%s has no program header", filename_print);
			return(-1);
		}
		loadaddr = hdr->loadaddr;
	}
	dp = (u_char *)loadaddr;
	for (fp = findstruct.frags, i = 0; i < findstruct.nfrags; fp++, i++) {
		fsize = fp->nblks * RT11FFS_AU_SIZE;
		bcopy_words(fp->addr, dp, fsize);
		dp += fsize;
	}
	last_load_addr = loadaddr;
	return(0);
}

static const struct keyword load_quals[] = {
	{"START", 1, 1},
	{NULL, 0, -1}};

cmd_load(cmd)
	char *cmd;
{
	struct param params[1];
	struct qual quals[3], *qual;
	u_long start;
	int start_given = 0;
	u_short filename_rad50[3];

	bzero(quals, sizeof(quals));
	if (parse_cmd(cmd, 1, 1, params, NULL, load_quals, quals))
		return(0);
	for (qual = quals; qual->id; qual++)
		switch (qual->id) {
		case 1:		/* /START */
			if (!qual->value) {
				error("Value qualifier");
				return(0);
			}
			start_given = 1;
			/* See what kind of address this is */
			if (is_hex_string(qual->value, qual->vallen)) {
				/* Pure numeric address */
				if (parse_hexnum(qual->value, qual->vallen,
						 &start))
					return(0);
			} else if (qual->vallen==1 && qual->value[0]=='*')
				start = last_memacc_addr;
			else {
				error("Illegal address");
				return(0);
			}
			if (start & 1) {
				error("Odd address");
				return(0);
			}
			break;
		}
	if (ascii_to_rad50_filename(params[0].text, params[0].len,
					filename_rad50, BIN_DEFEXT) < 0) {
		error("Invalid filename");
		return(0);
	}
	load_from_ffs(filename_rad50, start_given, start);
	return(0);
}

cmd_run(cmd)
	char *cmd;
{
	struct param params[1];
	u_short filename_rad50[3];
	struct program_header *hdr;
	void (*fptr)();

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (ascii_to_rad50_filename(params[0].text, params[0].len,
					filename_rad50, BIN_DEFEXT) < 0) {
		error("Invalid filename");
		return(0);
	}
	if (load_from_ffs(filename_rad50, 0) < 0)
		return(0);
	hdr = (struct program_header *)last_load_addr;
	fptr = (void (*)()) hdr->entry_point;
	(*fptr)();
	return(0);
}
