/*
 * HELP and FFS TEXTDUMP commands
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "mon302.h"
#include "rt11ffs.h"
#include "helpfile.h"
#include "../libffs/ffsimpl.h"

const u_short mon_hlp_filename[3] __attribute__ ((section (".rodata")))
	= {0x53A6, 0, HLP_DEFEXT};

dump_text_block(findstruct, offset)
	struct find_file_results *findstruct;
	u_long offset;
{
	struct fragment_info *fp, *endf;
	u_char *cp, *end;
	int c, linebeg;

	fp = findstruct->frags;
	endf = fp + findstruct->nfrags;
	while (fp < endf && offset >= fp->nblks * RT11FFS_AU_SIZE) {
		offset -= fp->nblks * RT11FFS_AU_SIZE;
		fp++;
	}
	if (fp >= endf)
		return;
	cp = fp->addr + offset;
	end = fp->addr + fp->nblks * RT11FFS_AU_SIZE;
	fp++;
	for (linebeg = 1; ; ) {
		if (check_intr())
			return;
		if (cp >= end) {
			if (fp >= endf)
				return;
			else {
				cp = fp->addr;
				end = cp + fp->nblks * RT11FFS_AU_SIZE;
				fp++;
			}
		}
		c = *cp++;
		if (isprint(c) || c == '\t') {
			putchar(c);
			linebeg = 0;
			continue;
		}
		switch (c) {
		default:
			if (linebeg)
				return;
			/* FALL THRU */
		case '\n':
			printf("\r\n");
			linebeg = 1;
			break;
		case '\r':
			continue;
		}
	}
}

help_engine(filename, topic)
	u_short *filename;
	char *topic;
{
	struct find_file_results findstruct;
	struct helpfile_index *ip, *endi;

	if (ffs_find_file_wrapper(filename, &findstruct) < 0)
		return(-1);
	ip = (struct helpfile_index *) findstruct.frags[0].addr;
	endi = (struct helpfile_index *)
		(findstruct.frags[0].addr +
		 findstruct.frags[0].nblks * RT11FFS_AU_SIZE);
	while (ip < endi) {
		if (!strncasecmp(topic, ip->topic, sizeof(ip->topic))) {
			dump_text_block(&findstruct, ip->offset);
			return(0);
		}
		if (!ip->topic[0])
			break;
		ip++;
	}
	error("Requested help topic not found");
	return(-1);
}

cmd_help(cmd)
	char *cmd;
{
	struct param params[1];

	bzero(params, sizeof params);
	if (parse_cmd(cmd, 0, 1, params, NULL, NULL, NULL))
		return(0);
	if (params[0].text) {
		params[0].text[params[0].len] = '\0';
		help_engine(mon_hlp_filename, params[0].text);
	} else
		help_engine(mon_hlp_filename, "");
	return(0);
}

cmd_ffs_textdump(cmd)
	char *cmd;
{
	struct param params[1];
	u_short filename_rad50[3];
	struct find_file_results findstruct;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (ascii_to_rad50_filename(params[0].text, params[0].len,
					filename_rad50, 0) < 0) {
		error("Invalid filename");
		return(0);
	}
	if (ffs_find_file_wrapper(filename_rad50, &findstruct) < 0)
		return(0);
	dump_text_block(&findstruct, 0L);
	return(0);
}
