# This routine provides a CPU-timed delay of a specified number of
# microseconds.  The math is as follows:
#
# The CPU clock may be up to 25 MHz, hence we need 25 clocks for each us.
# According to the MC68000 book, a NOP takes 4 clocks and
# a looping DBRA takes 10 clocks. Thus one iteration of a loop with 4 NOPs
# ending in DBRA takes 26 clocks. We thus perform N iterations when asked
# for a delay of N us and we should be safe.

	.text
	.globl	cpu_delay_us
cpu_delay_us:
	move.w	6(%sp),%d0
	subq.w	#1,%d0
1:	nop
	nop
	nop
	nop
	dbra	%d0,1b
	rts
