/*
 * RFC 1662 octet framing utility functions
 * used for Nokia EOC
 */

#include "types.h"

#define	CCITT_FCS16_INIT	0xffff		/* Initial FCS value */
#define	CCITT_FCS16_GOOD	0xf0b8		/* Good final FCS value */

extern u_short ccitt_fcs16tab[256];

rfc1662_decode(src, dest, lenp)
	u_char *src, *dest;
	int *lenp;
{
	u_char *cp, *dp, *end;
	int c, len;

	cp = src;
	dp = dest;
	end = src + *lenp;
	for (len = 0; cp < end; len++) {
		c = *cp++;
		if (c != 0x7D) {
			*dp++ = c;
			continue;
		}
		if (cp >= end)
			return(-1);
		c = *cp++;
		switch (c) {
		case 0x5D:
			*dp++ = 0x7D;
			break;
		case 0x5E:
			*dp++ = 0x7E;
			break;
		default:
			return(-1);
		}
	}
	*lenp = len;
	return(0);
}

rfc1662_fcs16_good(buf, len)
	u_char *buf;
	int len;
{
	u_short accum;

	accum = CCITT_FCS16_INIT;
	while (len--)
		accum = (accum >> 8) ^ ccitt_fcs16tab[(accum ^ *buf++) & 0xff];
	return(accum == CCITT_FCS16_GOOD);
}

rfc1662_append_fcs16(buf, len)
	u_char *buf;
	int len;
{
	u_short accum;

	accum = CCITT_FCS16_INIT;
	while (len--)
		accum = (accum >> 8) ^ ccitt_fcs16tab[(accum ^ *buf++) & 0xff];
	accum = ~accum;
	*buf++ = accum & 0xFF;
	*buf++ = accum >> 8;
	return(0);
}
