/*
 * This is a *very* primitive memory allocator:
 * no checks and no freeing of allocated memory.
 *
 * The intent is to have a way of allocating buffers
 * that is just slightly more graceful than bss.
 */

#include "types.h"

extern char end;

caddr_t malloc_end = &end;

caddr_t
malloc(size)
	size_t size;
{
	caddr_t ret;
	int dribble;

	dribble = (u_long)malloc_end & 3;
	if (dribble)
		malloc_end += (4 - dribble);
	ret = malloc_end;
	malloc_end += size;
	return(ret);
}
