#include "../libc/types.h"
#include "autobaud.h"

extern const u_char crc8_table[256];

ifctf_preact_setcrc(msg)
	union autobaud_msg *msg;
{
	u_char crc;

	crc = crc8_table[msg->bytes[0]];
	crc = crc8_table[crc ^ msg->bytes[1]];
	crc = crc8_table[crc ^ msg->bytes[2]];
	msg->bytes[3] = crc;
}

/* returns 1 if good, 0 if bad */
ifctf_preact_checkcrc(msg)
	union autobaud_msg *msg;
{
	u_char crc;

	crc = crc8_table[msg->bytes[0]];
	crc = crc8_table[crc ^ msg->bytes[1]];
	crc = crc8_table[crc ^ msg->bytes[2]];
	return(msg->bytes[3] == crc);
}
