/*
 * CM pre-activation sequence
 *
 * We implement CM pulse train detection by having copied CM's own logic
 * extracted from our disassembly of CR201s firmware.  Note, however,
 * that our disassembly was done on a quite ancient version (1.20.8)
 * of the factory boot image, not the downloadable one, so it's a very old
 * version of CM's code.  All magic numbers come from there.
 *
 * We could probably do a better job if a certain large DSL network operator
 * with CM DSLAMs were to pay us fairly for the work.
 */

#define	NO_CM_SPEEDS	9

#define	CM_MULTWAIT_METER	4096

/*
 * The FELM threshold values are specified here exactly as they are
 * to be loaded into the bitpump registers, no scaling.
 *
 * The values used currently are exactly what CM firmware version 1.20.8
 * runs with as evidenced by disassembly, but their optimalness is
 * debatable.  The code we've disassembled calls their version of
 * _SetMeterTimer() to set the meter timer to 4096, then calls their
 * version of _Aagc() to set AAGC to 12 dB.  The latter scales the FELM
 * thresholds for AAGC, but not for the meter timer - it's just like
 * the ZipWire version which expects DEFAULT_METER to be in effect.
 * Thus the FELM thresholds are not scaled by 4 for the meter like they
 * should have been, but they are scaled by 3 for AAGC - in contrast
 * when the ZipWire code is waiting for remote signal (initial LOS OFF),
 * it's running with FELM thresholds w/o AAGC scaling despite AAGC
 * being set to 9 or 12 dB.  So I really don't know what the optimal
 * thresholds should be...
 */
#define	CMPULSE_HIGHFELM_TH	12
#define	CMPULSE_LOWFELM_TH	6
