/*
 * AutoBaud message receiver
 */

#include "../libc/types.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/util.h"
#include "../lib8973/bpstate.h"
#include "abrecv_data.h"
#include "abrecv_tuning.h"

static void
meter_inthandler(wb)
	struct abrecv_workbuf *wb;
{
	DECLARE_PTR;
	u_char meter_low;
	u_short slm;

	switch (wb->state) {
	case ABRECV_STATE_HUNT:
		meter_low = BP_READ_REG(bp_ptr, slm_low);
		slm = BYTE2WORD(BP_READ_REG(bp_ptr, slm_high), meter_low);
		if (slm >= wb->slm_th)
			wb->onescount++;
		else
			wb->onescount = 0;
		if (wb->onescount < ABRECV_START_QUARTERS)
			return;
		/* got start bit */
		wb->state = ABRECV_STATE_RECEIVING;
		wb->data = 0;
		wb->mask = 0x80000000;
		wb->qtrcount = 0;
		wb->onescount = 0;
		return;
	case ABRECV_STATE_RECEIVING:
		meter_low = BP_READ_REG(bp_ptr, slm_low);
		slm = BYTE2WORD(BP_READ_REG(bp_ptr, slm_high), meter_low);
		if (slm >= wb->slm_th)
			wb->onescount++;
		wb->qtrcount++;
		if (wb->qtrcount < 4)
			return;
		if (wb->onescount >= ABRECV_ONE_MINQUARTERS)
			wb->data |= wb->mask;
		wb->mask >>= 1;
		wb->qtrcount = 0;
		wb->onescount = 0;
		if (!wb->mask)
			wb->state = ABRECV_STATE_GOTIT;
		return;
	case ABRECV_STATE_INITSKIP:
		meter_low = BP_READ_REG(bp_ptr, slm_low);
		slm = BYTE2WORD(BP_READ_REG(bp_ptr, slm_high), meter_low);
		if (slm >= wb->slm_th)
			wb->qtrcount = 0;
		else
			wb->qtrcount++;
		if (wb->qtrcount >= ABRECV_INITIAL_SILENCE) {
			wb->state = ABRECV_STATE_HUNT;
			wb->onescount = 0;
		}
		return;
	case ABRECV_STATE_PROBE_WAITFORHIGH:
		meter_low = BP_READ_REG(bp_ptr, slm_low);
		slm = BYTE2WORD(BP_READ_REG(bp_ptr, slm_high), meter_low);
		if (slm >= wb->slm_th)
			wb->qtrcount++;
		else
			wb->qtrcount = 0;
		if (wb->qtrcount >= ABRECV_PROBE_THRESHOLD) {
			wb->state = ABRECV_STATE_PROBE_WAITFORLOW;
			wb->qtrcount = 0;
		}
		return;
	case ABRECV_STATE_PROBE_WAITFORLOW:
		meter_low = BP_READ_REG(bp_ptr, slm_low);
		slm = BYTE2WORD(BP_READ_REG(bp_ptr, slm_high), meter_low);
		if (slm >= wb->slm_th)
			wb->qtrcount = 0;
		else
			wb->qtrcount++;
		if (wb->qtrcount >= ABRECV_PROBE_THRESHOLD)
			wb->state = ABRECV_STATE_PROBE_DONE;
		return;
	}
}

abrecv_install(wb)
	struct abrecv_workbuf *wb;
{
	DECLARE_PTR;
	DECLARE_MODE_PTR;
	u_short mtimer;
	u_long slmaccum;
	int s;

	wb->state = ABRECV_STATE_INACTIVE;
	mtimer = BP_global_state.symbol_rate * 50;
	slmaccum = (u_long)mtimer * ABRECV_SLM_TH;
	wb->slm_th = slmaccum >> 16;
	s = splup(1);
	BP_global_state.meter_tmr_inthandler = meter_inthandler;
	BP_global_state.meter_tmr_inthandler_param = (u_long) wb;
	_SetMeterArbitrary(mtimer);
	bp_mode_ptr->mask_low_reg.meter = 0;
	bp_ptr->timer_source = ~TIMERMASK_METER;
	splx(s);
	return(0);
}

abrecv_uninstall()
{
	DECLARE_MODE_PTR;

	bp_mode_ptr->mask_low_reg.meter = 1;
	BP_global_state.meter_tmr_inthandler = 0;
	return(0);
}

abrecv_arm(wb)
	struct abrecv_workbuf *wb;
{
	int s;

	s = splup(1);
	wb->state = ABRECV_STATE_INITSKIP;
	wb->qtrcount = 0;
	splx(s);
	return(0);
}

abrecv_arm_for_probe(wb)
	struct abrecv_workbuf *wb;
{
	int s;

	s = splup(1);
	wb->state = ABRECV_STATE_PROBE_WAITFORHIGH;
	wb->qtrcount = 0;
	splx(s);
	return(0);
}

abrecv_disarm(wb)
	struct abrecv_workbuf *wb;
{
	wb->state = ABRECV_STATE_INACTIVE;
	return(0);
}
