/*
 * RT11FFS code developed by Harhan Engineering Co.
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "ffsimpl.h"

extern struct rt11ffs_dirent ffs_segment_header;
extern struct rt11ffs_dirent blank_dirent;

ffs_scan_segment(segnum, doprint, results)
	int segnum;
	int doprint;
	struct segment_scan_results *results;
{
	caddr_t segbase;
	int active_blocks, dirty_blocks, free_blocks;
	int blkptr, active_dirblk;
	struct rt11ffs_dirent *dirptr;
	int dirindex, active_file_flag;
	int hit_error;
	int size, isfrag;
	char printname[16];

	segbase = (caddr_t)FLASH_BASE + segnum * FLASH_ERASEBLK_SIZE;
	dirptr = (struct rt11ffs_dirent *) segbase;
	if (bcmp(dirptr, &ffs_segment_header, sizeof ffs_segment_header)) {
		if (results)
			results->valid_seg = 0;
		return;
	}
	if (doprint)
		printf("FFS segment %X at %06X:\r\n\r\n", segnum, segbase);
	dirptr++;
	dirindex = 1;
	active_dirblk = 0;
	blkptr = 1;
	active_blocks = dirty_blocks = 0;
	free_blocks = FFS_AUs_PER_SEGMENT - 1;
	active_file_flag = 0;
	hit_error = 0;
	while (blkptr < FFS_AUs_PER_SEGMENT) {
		if (dirindex >= 64) {
			if (active_file_flag)
				active_blocks++;
			else
				dirty_blocks++;
			active_dirblk = blkptr++;
			free_blocks--;
			dirptr = (struct rt11ffs_dirent *)
				(segbase + active_dirblk * RT11FFS_AU_SIZE);
			dirindex = 0;
			active_file_flag = 0;
		}
		if (!bcmp(dirptr, &blank_dirent, sizeof(struct rt11ffs_dirent)))
			break;
		if (dirptr->filename[0] > 63999 || dirptr->filename[1] > 63999
		    || dirptr->filename[2] > 63999) {
			hit_error = 1;
			break;
		}
		size = dirptr->size_flags & RT11FFS_DIRENT_SIZEMASK;
		if (size < 1 || size > free_blocks) {
			hit_error = 1;
			break;
		}
		free_blocks -= size;
		if (dirptr->size_flags & RT11FFS_DIRENT_VALID) {
			active_blocks += size;
			if (doprint) {
				rad50_filename_to_ascii(dirptr->filename,
							printname);
				isfrag = (dirptr->size_flags &
				(RT11FFS_DIRENT_FIRST|RT11FFS_DIRENT_LAST)) !=
				(RT11FFS_DIRENT_FIRST|RT11FFS_DIRENT_LAST);
				printf("%06X: %s %5u%s\r\n",
					segbase + blkptr * RT11FFS_AU_SIZE,
					printname, size, isfrag ? "F" : "");
			}
			active_file_flag = 1;
		} else
			dirty_blocks += size;
		blkptr += size;
		dirptr++;
		dirindex++;
	}
	if (results) {
		results->valid_seg = 1;
		results->has_errs = hit_error;
		results->active_blocks = active_blocks;
		results->dirty_blocks = dirty_blocks;
		results->free_blocks = free_blocks;
		results->active_dirblk = active_dirblk;
		results->new_dirent_ptr = (caddr_t) dirptr;
		results->new_data_ptr = segbase + blkptr * RT11FFS_AU_SIZE;
	}
	if (doprint && hit_error)
		printf("WARNING: invalid directory entry at %06X, rest of segment skipped\r\n", dirptr);
	if (!hit_error) {
		for (; dirindex < 64; dirindex++) {
			if (bcmp(dirptr, &blank_dirent,
				 sizeof(struct rt11ffs_dirent)))
				break;
			dirptr++;
		}
		if (dirindex < 64) {
			if (doprint)
				printf("WARNING: garbage in active directory block at %06X\r\n", dirptr);
			if (results)
				results->has_errs++;
		}
	}
	if (doprint && !hit_error)
		printf("Allocation units: %d active, %d dirty, %d free\r\n",
			active_blocks, dirty_blocks, free_blocks);
	if (doprint)
		printf("\r\n");
}

ffs_scan_flash(doprint, results)
	int doprint;
	struct segment_scan_results *results;
{
	int i;

	for (i = FFS_MINSEG; i <= FFS_MAXSEG; i++)
		ffs_scan_segment(i, doprint, results ? results + (i-1) : NULL);
}
