/*
 * RT11FFS code developed by Harhan Engineering Co.
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"

rad50_word_to_ascii(rad50, ascii)
	u_short rad50;
	char ascii[3];
{
	int i;

	for (i = 2; i >= 0; i--) {
		u_char rchar;

		rchar = rad50 % 050;
		rad50 /= 050;
		switch (rchar) {
		case 000:
			ascii[i] = ' ';
			break;
		case 033:
			ascii[i] = '$';
			break;
		case 034:
			ascii[i] = '.';
			break;
		case 035:	/* RAD50 reserved */
			ascii[i] = '?';
			break;
		default:
			if (rchar >= 036)
				ascii[i] = rchar - 036 + '0';
			else
				ascii[i] = rchar - 001 + 'A';
		}
	}
}

rad50_filename_to_ascii(rad50, ascii)
	u_short *rad50;
	char *ascii;
{
	rad50_word_to_ascii(rad50[0], ascii);
	rad50_word_to_ascii(rad50[1], ascii + 3);
	ascii[6] = '.';
	rad50_word_to_ascii(rad50[2], ascii + 7);
	ascii[10] = '\0';
}

rad50_filename_to_ascii_trimspaces(rad50, ascii)
	u_short *rad50;
	char *ascii;
{
	char *cp;

	rad50_word_to_ascii(rad50[0], ascii);
	rad50_word_to_ascii(rad50[1], ascii + 3);
	cp = ascii + 6;
	while (cp > ascii && cp[-1] == ' ')
		cp--;
	*cp++ = '.';
	rad50_word_to_ascii(rad50[2], cp);
	cp += 3;
	while (cp[-1] == ' ')
		cp--;
	*cp = '\0';
}

ascii_to_rad50_word(ascii, rad50)
	char ascii[3];
	u_short *rad50;
{
	int i;
	u_short accum = 0;

	for (i = 0; i <= 2; i++) {
		char ch;
		u_char rchar;

		ch = ascii[i];
		if (isupper(ch))
			rchar = ch - 'A' + 001;
		else if (islower(ch))
			rchar = ch - 'a' + 001;
		else if (isdigit(ch))
			rchar = ch - '0' + 036;
		else if (ch == ' ')
			rchar = 000;
		else if (ch == '$')
			rchar = 033;
		else if (ch == '.')
			rchar = 034;
		else
			return(-1);
		accum = accum * 050 + rchar;
	}
	*rad50 = accum;
	return(0);
}

ascii_to_rad50_filename(text, len, rad50, default_ext)
	char *text;
	int len;
	u_short *rad50, default_ext;
{
	char filename[6], filetype[3];
	char *cp, *dp, *endp;
	int i;

	endp = text + len;
	for (cp = text, dp = filename, i = 0; cp < endp; i++) {
		if (*cp == '.')
			break;
		if (!isalnum(*cp) && *cp != '$')
			return(-1);
		if (i >= 6)
			return(-1);
		*dp++ = *cp++;
	}
	if (!i)
		return(-1);
	for (; i < 6; i++)
		*dp++ = ' ';
	ascii_to_rad50_word(filename, rad50);
	ascii_to_rad50_word(filename + 3, rad50 + 1);
	if (cp >= endp) {
		rad50[2] = default_ext;
		return(0);
	}
	*cp++;	/* skip '.' */
	for (dp = filetype, i = 0; cp < endp; i++) {
		if (!isalnum(*cp) && *cp != '$')
			return(-1);
		if (i >= 3)
			return(-1);
		*dp++ = *cp++;
	}
	for (; i < 3; i++)
		*dp++ = ' ';
	ascii_to_rad50_word(filetype, rad50 + 2);
	return(0);
}
