/*
 * The structures defined in this header file are the volatile (RAM-based)
 * data structures used by the FFS code, not the actual in-flash data
 * structures of RT11FFS.  See ../include/rt11ffs.h for the latter.
 */

#ifndef __FFSIMPL_H
#define	__FFSIMPL_H

struct segment_scan_results {
	int	valid_seg;
	int	has_errs;
	int	active_blocks;
	int	dirty_blocks;
	int	free_blocks;
	int	active_dirblk;
	caddr_t	new_dirent_ptr;
	caddr_t	new_data_ptr;
};

struct fragment_info {
	caddr_t	addr;
	int	nblks;
};

struct find_file_results {
	int	nfrags;
	int	total_size;
	struct	fragment_info frags[FFS_NSEGS];
};

#define	FIND_STAT_FOUND		1
#define	FIND_STAT_NOTFOUND	0
#define	FIND_STAT_INVALID_DIR	-1
#define	FIND_STAT_INVALID_FRAG	-2

#endif
