/*
 * Linkage for applications using SDCORE shared library
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "monitor_api.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"

static const u_short sdcore_filename[3] __attribute__ ((section (".rodata")))
	= {0x7763, 0x6095, 0x0DF6};

struct sdcore_api *
fetch_sdcore()
{
	struct program_header *hdr;
	struct sdcore_api *apitab;

	if (monapi_ffsload(sdcore_filename, 0) < 0) {
		/* error message already printed */
		return(0);
	}
	hdr = (struct program_header *) monapi_getloadaddr();
	apitab = (struct sdcore_api *) hdr->api_table_ptr;
	if (!apitab || apitab->sdcore_magic != SDCORE_MAGIC) {
		printf("Error: SDCORE.BIN has no valid API table\r\n");
		return(0);
	}
	if (apitab->sdcore_hwtype != SDCORE_HWTYPE ||
	    apitab->sdcore_api_ver != SDCORE_APIVER ||
	    apitab->sizeof_apitable != sizeof(struct sdcore_api) ||
	    apitab->sizeof_state != sizeof(struct sdcore_state)) {
		printf("Error: SDCORE ABI version mismatch\r\n");
		return(0);
	}
	/* everything good, return API table pointer */
	return(apitab);
}
