/*
 * Linkage for applications using OPCORE shared library
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "monitor_api.h"
#include "../opcore/api.h"

static const u_short opcore_filename[3] __attribute__ ((section (".rodata")))
	= {0x6043, 0x6095, 0x0DF6};

struct opcore_api *
fetch_opcore()
{
	struct program_header *hdr;
	struct opcore_api *apitab;

	if (monapi_ffsload(opcore_filename, 0) < 0) {
		/* error message already printed */
		return(0);
	}
	hdr = (struct program_header *) monapi_getloadaddr();
	apitab = (struct opcore_api *) hdr->api_table_ptr;
	if (!apitab || apitab->opcore_magic != OPCORE_MAGIC) {
		printf("Error: OPCORE.BIN has no valid API table\r\n");
		return(0);
	}
	if (apitab->opcore_api_ver != OPCORE_APIVER ||
	    apitab->sizeof_apitable != sizeof(struct opcore_api)) {
		printf("Error: OPCORE ABI version mismatch\r\n");
		return(0);
	}
	/* everything good, return API table pointer */
	return(apitab);
}
