/*
 * Linkage for applications using L2CONV shared library
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "monitor_api.h"
#include "../l2conv/api.h"

static const u_short l2conv_filename[3] __attribute__ ((section (".rodata")))
	= {0x5003, 0x6006, 0x0DF6};

struct l2conv_api *
fetch_l2conv()
{
	struct program_header *hdr;
	struct l2conv_api *apitab;

	if (monapi_ffsload(l2conv_filename, 0) < 0) {
		/* error message already printed */
		return(0);
	}
	hdr = (struct program_header *) monapi_getloadaddr();
	apitab = (struct l2conv_api *) hdr->api_table_ptr;
	if (!apitab || apitab->l2conv_magic != L2CONV_MAGIC) {
		printf("Error: L2CONV.BIN has no valid API table\r\n");
		return(0);
	}
	if (apitab->l2conv_api_ver != L2CONV_APIVER ||
	    apitab->sizeof_apitable != sizeof(struct l2conv_api)) {
		printf("Error: L2CONV ABI version mismatch\r\n");
		return(0);
	}
	/* everything good, return API table pointer */
	return(apitab);
}
