#include "types.h"
#include "stdio.h"
#include <varargs.h>
#include "../include/mc68302.h"

extern char _printf_buffers[4][128];
extern u_short _printf_curbd;
extern volatile struct mc68302_scc_bd scc3_tx_bds[4];

int
printf(va_alist)
	va_dcl
{
	va_list ap;
	char *fmt;
	int len;
	register int i;

	_printf_wait_for_bd();
	i = _printf_curbd;
	va_start(ap);
	fmt = va_arg(ap, char *);
	len = _doprnt(fmt, ap, _printf_buffers[i]);
	va_end(ap);
	scc3_tx_bds[i].bd_len = len;
	scc3_tx_bds[i].bd_flags |= 0x8000;
	i += 1;
	if (i >= 4)
		i = 0;
	_printf_curbd = i;
	return(len);
}
