/**************************************************************/
/*    UTIL.H                                                  */
/*                                                            */
/* Description:                                               */
/*    This header file defines various junk macros            */
/*    used by the code inherited from ZipWire		      */
/*                                                            */
/* Notes:                                                     */
/*                                                            */
/* User Modifiable Code:                                      */
/*    None                                                    */
/*                                                            */
/* List of H files included in this module:                   */
/*                                                            */
/* Programmer:                                                */
/*     Iris Shuker                21-Oct-1993                 */
/*                                                            */
/* Revision History:                                          */
/*                                                            */
/**************************************************************/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

#define RESET 0
#define ON  1
#define OFF 0

#define TABLE_LENGTH                64


/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

#define LOW(x) (BP_S_8BIT)(x)

#define HIGH(x) LOW((x) >> 8)

#define HIGHER(x) LOW((x) >> 16)

#define HIGHEST(x) LOW((x) >> 24)

#define LOW_WORD(x) (BP_S_16BIT) (x)

#define HIGH_WORD(x) LOW_WORD((x) >> 16)

#define SET_HIGH(x) (((BP_U_16BIT)(x)) << 8)

#define BYTE2WORD(x, y) (SET_HIGH(x) | (((BP_U_16BIT)(y)) & 0xFF))

#define BYTE2_32BIT(d,c,b,a)  \
( (BP_U_32BIT) ( (BP_U_32BIT)(BYTE2WORD(d,c))<<16) | ((BP_U_32BIT)(BYTE2WORD(b,a)) ))

#define SET_WORD(ptr, low, high, value) \
    BP_WRITE_REG(ptr, low, LOW(value));\
    BP_WRITE_REG(ptr, high, HIGH(value));

/* 
 * READ_METER_REG
 *
 * Must pass in 'meter_low/high' (i.e. slm_low), 'value' (return value)
 * and 'meter' (must be NORMalized first, or 0)
 *
 * Disables interrupts
 */
#define READ_METER_REG(meter_low, meter_high, value, meter) \
{   BP_S_8BIT low;\
    int saveipl;\
    saveipl = splup(1);\
    low = BP_READ_REG(bp_ptr, meter_low);\
    value = (BYTE2WORD(BP_READ_REG(bp_ptr, meter_high), low)) << meter;\
    splx(saveipl);\
}

#define NORM(x) x = _NormlizeMeter(); 

#define WR_WORD(address, low_value, high_value) {	\
	unsigned char wrword_temp[2];			\
	wrword_temp[0] = (low_value);			\
	wrword_temp[1] = (high_value);			\
	bp_eq_write((address), wrword_temp);		\
	}
