#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "bpstate.h"

get_txgain_default()
{
    DECLARE_MODE_PTR;
    BP_S_8BIT cal_tx_gain;

    /* Read Calibrated Tx Gain */
    cal_tx_gain = BP_READ_BIT(bp_mode_ptr, tx_calibrate, tx_gain);

    switch (GET_BITPUMP_TYPE()) {
#if SUPPORT_BT8970
    case BT8970:
        /* This sets any parts that missed production testing.
         * If the device is a Bt8970-12 and it has not been calibrated by
         * the factory.  A un-tested part will have a '0' as the Tx Gain.
         * To compensate, set the tx_gain to a value of 0x03.
         * This value is based on test data.
         */ 
	if ((BP_READ_BIT(bp_mode_ptr, global_modes, hw_revision) == 0x02) &&
	    (cal_tx_gain == 0)) {
		/* force new Tx Gain to 0x03 */
		cal_tx_gain = 0x03;
	}
	break;
#endif
#if SUPPORT_RS8973
    case RS8973:
        /* 
         * Due to the use of a low inductance transformer, the transmit gain
         * should be increased at slower data rates. The following algorithm
         * checks the gain value and raises it by the appropriate level.
         * See BP4.2 Release Notes.
         */

        /* Convert 4-bit signed to 8-bit signed value */
        if (cal_tx_gain & 0x08)
            {
            cal_tx_gain |=0xF0;
            }

        if(BP_global_state.symbol_rate <= 18) /* <= 144kbps */
            {
            cal_tx_gain += 5;
            }
        else if(BP_global_state.symbol_rate <= 26) /* <= 208kbps */
            {
            cal_tx_gain += 3;
            }
        else if(BP_global_state.symbol_rate <= 42) /* <= 336kbps */
            {
            cal_tx_gain += 2;
            }
        else if(BP_global_state.symbol_rate <= 66) /* <= 528kbps */
            {
            cal_tx_gain += 1;
            }

        /* TX-Gain register can be a maximum of 7 */
        if ( cal_tx_gain > 7 )
            {
            cal_tx_gain = 7;
            }
	break;
#endif
    }

    return cal_tx_gain & 0x0F;
}
