/*
 * This header file defines some macros for messing with timers,
 * used by the startup / analog test code inherited from ZipWire.
 *
 * The goal is to make porting from ZipWire as simple as possible,
 * but there is one change: whereas the original ZipWire version
 * went through the interrupt handler which did nothing more than
 * set a software flag for polling, we poll the bitpump registers
 * directly.
 *
 * We also have to use the new TIMERMASK_* mechanism instead of
 * the old bit fields.
 */

#define	RESTART_METER	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_METER;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_METER;	\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, meter, ON);	\
    splx(s);}

#define	RESTART_SNR	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_SNR;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_SNR;	\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, snr, ON);		\
    splx(s);}

#define	RESTART_T3	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_T3;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_T3;		\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, t3, ON);		\
    splx(s);}

#define	RESTART_T4	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_T4;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_T4;		\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, t4, ON);		\
    splx(s);}

#define	RESTART_SUT1	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_SUT1;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_SUT1;	\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, sut1, ON);		\
    splx(s);}

#define	RESTART_SUT2	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_SUT2;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_SUT2;	\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, sut2, ON);		\
    splx(s);}

#define	RESTART_SUT3	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_SUT3;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_SUT3;	\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, sut3, ON);		\
    splx(s);}

#define	RESTART_SUT4	{	\
    int s;							\
    s = splup(1);						\
    bp_ptr->timer_source = ~TIMERMASK_SUT4;			\
    BP_global_state.latched_timer_irq &= ~TIMERMASK_SUT4;	\
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, sut4, ON);		\
    splx(s);}

#define	TIMER_BREAK(mask)	\
	if (!(bp_ptr->timer_source & mask))	\
		break;				\
	bp_ptr->timer_source = ~mask;

#define	WAIT_FOR_TIMER(mask)	\
	while (!(bp_ptr->timer_source & mask))	\
		;				\
	bp_ptr->timer_source = ~mask;
