/*
 * This function turns a value measured inside the bitpump
 * into a measure of what's on the line outside.
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"

u_short
_ScaleByGain(value)
	u_short value;
{
	DECLARE_MODE_PTR;
	int gain;

	gain = bp_mode_ptr->adc_control.again;
	switch (gain) {
        case AGAIN0DB: /* Really -3dB */
            /* value+value/4+value/8+value/32 = 1.40625*value (1.4142*value) */
            value += (value>>2) + (value>>3) + (value>>5);
            break;
        case AGAIN3DB:  /* Really 0dB */
            /* No change */
            break;
        case AGAIN6DB:  /* Really 3dB */ 
            /* value/2+value/8+value/16+value/32 = 0.71875*value (0.707*value) */
            value = (value >> 1) + (value >> 3) + (value >> 4) +\
            (value >> 5);
            break;
        case AGAIN9DB:  /* Really 6dB */
            /* 0.5*value */
            value >>= 1;
            break;
        case AGAIN12DB:  /* Really 9dB */
            /* 0.5*0.71875*value = 0.359375*value (0.3548*value) */
            value >>= 1;
            value = (value >> 1) + (value >> 3) + (value >> 4) +\
            (value >> 5);
            break;
        case AGAIN15DB:  /* Really 12dB */
            /* 0.25*value */
            value >>= 2;
            break;
        }
	return (value);

} /* End _ScaleByGain() */
