/*
 * A handy function to check whether the data rate requested by the user
 * is supported or not before we go too far with it.
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"

is_datarate_supported(rate)
{
	DECLARE_MODE_PTR;

	if (rate % 8)
		return(0);

	switch (GET_BITPUMP_TYPE()) {
#if SUPPORT_BT8970
	case BT8970:
		switch (rate) {
		/* list matching what's implemented in icd2053.c */
		case 144:
		case 160:
		case 192:
		case 208:
		case 272:
		case 288:
		case 320:
		case 384:
		case 392:
		case 400:
		case 416:
		case 528:
		case 768:
		case 784:
		case 1040:
		case 1152:
		case 1168:
		case 1536:
		case 1552:
		case 1568:
			return(1);
		default:
			return(0);
		}
#endif
#if SUPPORT_RS8973
	case RS8973:
		if (rate >= 144 && rate <= 2320)
			return(1);
		else
			return(0);
#endif
	default:
		return(0);
	}
}
