/*
 * These utility functions assist with reading and writing
 * the indirectly-accessed memory areas in the bitpump
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"

bp_lec_read(regno, buf)
	int regno;
	u_char *buf;
{
	DECLARE_PTR;
	int s;

	s = splup(1);
	BP_WRITE_REG(bp_ptr, linear_ec_tap_select_read, regno);
	DELAY2SYMBOL;
	buf[0] = BP_READ_REG(bp_ptr, access_data_byte0);
	buf[1] = BP_READ_REG(bp_ptr, access_data_byte1);
	buf[2] = BP_READ_REG(bp_ptr, access_data_byte2);
	buf[3] = BP_READ_REG(bp_ptr, access_data_byte3);
	splx(s);
}

bp_lec_write(regno, buf)
	int regno;
	u_char *buf;
{
	DECLARE_PTR;
	int s;

	s = splup(1);
	BP_WRITE_REG(bp_ptr, access_data_byte0, buf[0]);
	BP_WRITE_REG(bp_ptr, access_data_byte1, buf[1]);
	BP_WRITE_REG(bp_ptr, access_data_byte2, buf[2]);
	BP_WRITE_REG(bp_ptr, access_data_byte3, buf[3]);
	BP_WRITE_REG(bp_ptr, linear_ec_tap_select_write, regno);
	DELAY2SYMBOL;
	splx(s);
}

bp_dfe_read(regno, buf)
	int regno;
	u_char *buf;
{
	DECLARE_PTR;
	int s;

	s = splup(1);
	BP_WRITE_REG(bp_ptr, dfe_tap_select_read, regno);
	DELAY2SYMBOL;
	buf[0] = BP_READ_REG(bp_ptr, access_data_byte0);
	buf[1] = BP_READ_REG(bp_ptr, access_data_byte1);
	splx(s);
}

bp_eq_read(regno, buf)
	int regno;
	u_char *buf;
{
	DECLARE_PTR;
	int s;

	s = splup(1);
	BP_WRITE_REG(bp_ptr, eq_add_read, regno);
	DELAY2SYMBOL;
	buf[0] = BP_READ_REG(bp_ptr, access_data_byte0);
	buf[1] = BP_READ_REG(bp_ptr, access_data_byte1);
	splx(s);
}

bp_eq_write(regno, buf)
	int regno;
	u_char *buf;
{
	DECLARE_PTR;
	int s;

	s = splup(1);
	BP_WRITE_REG(bp_ptr, access_data_byte0, buf[0]);
	BP_WRITE_REG(bp_ptr, access_data_byte1, buf[1]);
	BP_WRITE_REG(bp_ptr, eq_add_write, regno);
	DELAY2SYMBOL;
	splx(s);
}
