/*
 * This function must be called by whatever code is responsible
 * for the first contact with the bitpump from power-up.
 *
 * On the OSDCU the base monitor will call this function followed by
 * bp_power_down().
 */

#include "../libc/types.h"
#include "../include/mc68302.h"
#include "../include/intr.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "bpstate.h"

extern caddr_t m68000_vectors[];
extern volatile struct mc68302_regs mc68302_regs;

extern char _Xvec_bitpump;

int
lib8973_first_init()
{
	DECLARE_PTR;
	DECLARE_MODE_PTR;

	/* global state structure */
	bzero(&BP_global_state, sizeof BP_global_state);
	/* interrupt vector */
	m68000_vectors[INTVEC_IRQ1] = &_Xvec_bitpump;
	/* now mimic the old ZipWire library init */
	BP_WRITE_REG(bp_ptr, misc_test, RESET);
	DELAY2SYMBOL;
	BP_WRITE_BIT(bp_mode_ptr, serial_monitor_source, hclk_freq,
		_HCLK_DEFAULT); /* good HCLK */
	BP_WRITE_REG(bp_ptr, cu_interface_modes, _SERIAL_SIGNFIRST); /* BCLK */
	BP_WRITE_BIT(bp_mode_ptr, global_modes, mode, OFF); /* power on */
	BP_WRITE_REG(bp_ptr, mask_low_reg, MASK_ALL); /* Mask all interrupts */
	BP_WRITE_REG(bp_ptr, mask_high_reg, MASK_ALL); /* Mask all interrupts */

	return(_SelfTest());
}
